%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%data_props.m

%Shows dialog box with raw data information.
%If any data manipulation is performed, pressing data info will give the
%updated information.
%Besides info about the raw data, info about your restricted dataset is also shown.
function data_props

%Defined in load_data
global filename;
%Defined in plot_raw_data
global xdata_raw ydata_raw wave_raw
%Defined in load_calibration
global calib_waves calibfilename

%#########################
%Check if data is loaded
if exist('data')==0
    data=load (filename);
    ydata_raw=data(:,2:end);
    xdata_raw=data(:,1);
    wave_raw=1:size(ydata_raw,2);
end
    
%If dataset is calibrated, show min/max values of wavelengths
if exist('calib_waves')==0 || length(calibfilename)<19
    if numel(wave_raw)==0
        calib_text1=['Minimum value:         ',num2str(0)];
        calib_text2=['Maximum value:         ',num2str(0)];
    elseif numel(wave_raw)>0
        calib_text1=['Minimum value:         ',num2str(1)];
        calib_text2=['Maximum value:         ',num2str(size(ydata_raw,2))];
    end
    wave_raw=1:size(ydata_raw,2);
elseif exist('calib_waves')==0 || length(calibfilename)>19
    if exist('calibfilename')==1
        calib_waves=load (calibfilename);
    elseif exist('calibfilename')==0 || isempty('calibfilename')==1
        wave_raw=1:size(ydata_raw,2);
    end
    calib_text1=['Minimum value:         ',num2str(min(calib_waves))];
    calib_text2=['Maximum value:         ',num2str(max(calib_waves))];
    wave_raw=calib_waves;
elseif exist('calib_waves')==1
    calib_text1=['Minimum value:         ',num2str(min(calib_waves))];
    calib_text2=['Maximum value:         ',num2str(max(calib_waves))];
    wave_raw=calib_waves;
end

%#########################
%Get parameters from gui
time_shift=str2double(get(findobj('Tag','time_shift_box'),'String'));
wave_shift=str2double(get(findobj('Tag','wave_shift_box'),'String'));
time_limits(1)=str2double(get(findobj('Tag','time_lim_box1'),'String'));
time_limits(2)=str2double(get(findobj('Tag','time_lim_box2'),'String'));
wave_limits(1)=str2double(get(findobj('Tag','wave_lim_box1'),'String'));
wave_limits(2)=str2double(get(findobj('Tag','wave_lim_box2'),'String'));
time_divider=str2double(get(findobj('Tag','time_divider_box'),'String'));
wave_divider=str2double(get(findobj('Tag','wave_divider_box'),'String'));

%Create test matrix that determines if to show user-manipulated data as
%well
manip_tester=[time_shift,wave_shift,time_limits,wave_limits,time_divider,wave_divider];

%#########################
if isempty(find(manip_tester, 1))==1 %Check for non-zero elements in manip_testter
    %This dialog box is shown when no data manipulation is performed
    h = helpdlg({['Size of dataset:       ',num2str(size(ydata_raw,1)),' x ',num2str(size(ydata_raw,2))];'';...
        ['Number of timepoints:  ',num2str(length(xdata_raw))];...
        ['Minimum value:         ',num2str(min(xdata_raw))];...
        ['Maximum value:         ',num2str(max(xdata_raw))];...
        ' ';['Number of wavelengths: ',num2str(length(wave_raw))];
        calib_text1;calib_text2},...
        'Raw data properties');
    set(h,'Position',[314.25 226.5 270 150])
elseif isempty(find(manip_tester, 1))==0
    %If one of the data manipulation boxes is non-zero, show different dialog
     
    ydata=ydata_raw;
    xdata=xdata_raw;
    %############
    
    %Data manipulation
    xdata=xdata+time_shift;     %Shift time axis with specified amount
    if isempty(calib_waves)==1
        wave=wave_raw+wave_shift;
    elseif isempty(calib_waves)==0
        wave=calib_waves+wave_shift; %Shift wavelength axis with specified amount
        if length(wave)~=size(data,2)-1
            errordlg('Calibration file does not match datafile!');
            error('Calibration file does not match datafile!');
        end
    end
    if time_limits(1)~=time_limits(2) && (time_limits(1)==0 || time_limits(2)==0)
        errordlg('Time limits need to be both zero both unequal to zero!')
        error('Time limits need to be both zero both unequal to zero!');
    end
    if wave_limits(1)~=wave_limits(2) && (wave_limits(1)==0 || wave_limits(2)==0)
        errordlg('Wavelength limits need to be both zero both unequal to zero!')
        error('Wavelength limits need to be both zero both unequal to zero!');
    end
    
    if time_limits(2)-time_limits(1)> length(xdata)
        errordlg('Time limits exceeded. Set time range to 0 and 0 to find out correct limits!')
        error('Time limits exceeded. Set time range to 0 and 0 to find out correct limits!');
    end
    if wave_limits(2)-wave_limits(1)> length(wave)
        errordlg('Wavelength limits exceeded. Set wavelength range to 0 and 0 to find out correct limits!')
        error('Wavelength limits exceeded. Set wavelength range to 0 and 0 to find out correct limits!');
    end
    
    if time_limits(1)~=time_limits(2) && time_limits(1)~=0 && time_limits(2)~=0 && wave_limits(1)==wave_limits(2) && wave_limits(1)==0
        xdata=xdata(time_limits(1):time_limits(2));
        ydata=ydata(time_limits(1):time_limits(2),:);
    end
    if wave_limits(1)~=wave_limits(2) && wave_limits(1)~=0 && wave_limits(2)~=0 && time_limits(1)==time_limits(2) && time_limits(1)==0
        wave=wave(wave_limits(1):wave_limits(2));
        ydata=ydata(:,wave_limits(1):wave_limits(2));
    end
    if time_limits(1)~=time_limits(2) && time_limits(1)~=0 && time_limits(2)~=0 && wave_limits(1)~=wave_limits(2) && wave_limits(1)~=0 && wave_limits(2)~=0
        xdata=xdata(time_limits(1):time_limits(2));
        ydata=ydata(time_limits(1):time_limits(2),wave_limits(1):wave_limits(2));
        wave=wave(wave_limits(1):wave_limits(2));
    end
    
    if wave_divider>1;
        ydata=ydata(:,1:wave_divider:end);
        wave=wave(1:wave_divider:end);
    end
    if time_divider>1;
        xdata=xdata(1:time_divider:end,1);
        ydata=ydata(1:time_divider:end,:);
    end
    %############
    
    %The new help dialog pop-up box becomes
    h = helpdlg({['Size of dataset:       ',num2str(size(ydata_raw,1)),' x ',num2str(size(ydata_raw,2))];'';...
        ['Number of timepoints:  ',num2str(length(xdata_raw))];...
        ['Minimum value:         ',num2str(min(xdata_raw))];...
        ['Maximum value:         ',num2str(max(xdata_raw))];...
        ' ';['Number of wavelengths: ',num2str(length(wave_raw))];
        calib_text1;calib_text2;'';'User-modified dataset';...
        ['Size of dataset:       ',num2str(size(ydata,1)),' x ',num2str(size(ydata,2))];'';...
        ['Number of timepoints:  ',num2str(length(xdata))];...
        ['Minimum value:         ',num2str(xdata(1))];...
        ['Maximum value:         ',num2str(xdata(end))];...
        ' ';['Number of wavelengths: ',num2str(length(wave))];...
        ['Minimum value:         ',num2str(wave(1))];...
        ['Maximum value:         ',num2str(wave(end))]},...
        'Raw and user-constraint data properties');
    set(h,'Position',[314.25 226.5 270.25 250])
end

%Clean up
clear calib_text1 calib_text2 h manip_tester
clear time_divider wave_divider time_limits wave_limits time_shift wave_shift