%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%export_figs2jpg.m

function export_figs2jpg
%Exporting all open figures to jpeg format, 300dpi resolution as default

prompt = {'Enter resolution (dpi) for .fig -> .jpc conversion:'};
dlg_title = 'fig->jpg';
num_lines = 1;
def = {'300'};
resolution_figs = inputdlg(prompt,dlg_title,num_lines,def);
resolution_figs=resolution_figs{1}; %Because inputdlg creates a structure in stead of double
clear prompt dlg_title num_lines def

if size(resolution_figs,2)==2
    pc_length=17;
elseif size(resolution_figs,2)==3
    pc_length=18;
elseif size(resolution_figs,2)==4
    pc_length=19;
end

directory_name_jpgs=uigetdir(pwd,'Select folder to export jpgs');
cd (directory_name_jpgs);
print_com=['print -djpeg -r' resolution_figs];
clear resolution_figs

if isempty(findobj('Name','Loaded_raw_data'))==0
    figure(findobj('Name','Loaded_raw_data'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' raw_data'];
    eval(print_com)
    clear h 
end
if isempty(findobj('Name','Dispersion estimation'))==0
    figure(findobj('Name','Dispersion estimation'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' dispers_estim'];
    eval(print_com)
    clear h 
end
if isempty(findobj('Name','Loaded dispersion curve'))==0
    figure(findobj('Name','Loaded dispersion curve'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' loaded_dispers'];
    eval(print_com)
    clear h 
end
if isempty(findobj('Name','Raw data Concentration profiles'))==0
    figure(findobj('Name','Raw data Concentration profiles'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' raw_conc_prof'];
    eval(print_com)
    clear h 
end
if isempty(findobj('Name','trace1'))==0
    figure(findobj('Name','trace1'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' trace1'];
    eval(print_com)
    clear h 
end
if isempty(findobj('Name','spectra'))==0
    figure(findobj('Name','spectra'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' spectra'];
    eval(print_com) 
    clear h 
end
if isempty(findobj('Name','trace2'))==0
    figure(findobj('Name','trace2'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' trace2'];
    eval(print_com)  
    clear h 
end
if isempty(findobj('Name','trace3'))==0
    figure(findobj('Name','trace3'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' trace3'];
    eval(print_com)  
    clear h 
end
if isempty(findobj('Name','trace4'))==0
    figure(findobj('Name','trace4'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' trace4'];
    eval(print_com)  
    clear h 
end
if isempty(findobj('Name','trace5'))==0
    figure(findobj('Name','trace5'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' trace5'];
    eval(print_com)  
    clear h 
end
if isempty(findobj('Name','trace6'))==0
    figure(findobj('Name','trace6'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' trace6'];
    eval(print_com)  
    clear h 
end
if isempty(findobj('Name','Explore fit'))==0
    figure(findobj('Name','Explore fit'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' fit_explorer'];
    eval(print_com)  
    clear h 
end
if isempty(findobj('Name','residuals'))==0
    figure(findobj('Name','residuals'));
    h=gcf;
    print_com=[print_com(1:pc_length) ' -f' num2str(h) ' residuals'];
    eval(print_com)  
    clear h     
end