%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%fit_explorer_plot.m

function fit_explorer_plot

%Defined in fit_data
global filename wave xdata ydata
global time_limits wave_limits 
global axis_switch nr_svd_comps SVDcontrib_switch
global lin_log

%Defined in globfit_bio_gui
global y_fit

%Disable 'negative timepoints' warning if logarithmic time axis used. Is
%switched back on at end of this file
warning('off','MATLAB:Axes:NegativeDataInLogAxis')

%Basically same interactive plot as data_explorer plot, but now also with fits
[trace_plot,wave_plot]=ginput(1); %Get mouse position when clicked inside
%surface plot.

%Trick to get datapoint closest to mouse position
[~,wave_plot_ind]=min(abs(wave_plot-wave));
[~,trace_plot_ind]=min(abs(trace_plot-xdata));

%------Plotting-------
%Raw data surface plot
subplot(3,3,[1:2,4:5])
cla;
if time_limits==0
    time_limits(1)=1;
    time_limits(2)=size(xdata,1);
end
if wave_limits==0
    wave_limits(1)=1;
    wave_limits(2)=size(wave,2);
end
pcolor(xdata,wave,ydata(:,:)');%time_limits(1):time_limits(2),wave_limits(1):wave_limits(2))')
colorbar
shading interp;
    title({'Click in surface plot to activate cross-hair, click again for slice selection',['Datafile: ' filename]},'Interpreter','None');    %The TEX Interpreter is switched off to prevent error message due to possible interpretation of forward slashes
xlabel('Time');
ylabel('Wavelength');
hold on;

%Plot lines where mouse is clicked
plot(xdata,wave(wave_plot_ind)*(ones(size(xdata))),'k')
plot(xdata(trace_plot_ind)*(ones(size(wave))),wave,'k')

%Time axis toggle. If not switched on, all time axes are logarithmic.
if lin_log==0
    set(gca,'XScale','log');
end
set(gca,'YDir','reverse');
if axis_switch==1 && nr_svd_comps==0 && SVDcontrib_switch==0
    set(gca,'YDir','normal');
end

%Time trace plot
subplot(3,3,7:8)
cla;
plot(xdata,ydata(:,wave_plot_ind),'k');%time_limits(1):time_limits(2),wave_plot_ind))
hold on;
plot(xdata,y_fit(:,wave_plot_ind),'b');%time_limits(1):time_limits(2),wave_plot_ind),'r')
if lin_log==0
    set(gca,'XScale','log');
end
xlabel(['Time trace at wavelength ',num2str(wave(wave_plot_ind))]);
clear wave_plot_ind
axis tight;
grid on;

%Spectrum plot
subplot(3,3,[3,6])
cla;
plot(wave,ydata(trace_plot_ind,:),'k');%wave_limits(1):wave_limits(2)))
hold on;
plot(wave,y_fit(trace_plot_ind,:),'b');%wave_limits(1):wave_limits(2)),'r')
xlabel(['Spectrum at timepoint ',num2str(xdata(trace_plot_ind))]);
clear trace_plot_ind
axis tight;
if axis_switch==1 && nr_svd_comps==0 && SVDcontrib_switch==0
    set(gca,'XDir','reverse');
end
legend('Raw data','Fit');
set(findobj('Tag','legend'),'Position',[0.75 0.15 0.0929 0.0942]);
grid on;

%Turn warning about negative timepoints back on again (see above)
warning('on','MATLAB:Axes:NegativeDataInLogAxis')