%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%load_dispersion.m

function load_dispersion

%Defined in plot_raw_data
global filename;
%Defined here
global dispersfilename delay_shift_curve

delay_shift_curve=[];
[dispersFileName,dispersPathName] = uigetfile('*.dat','Select dispersion file');

dispersfilename=strcat(dispersPathName,dispersFileName);
if length(dispersfilename)<97
    set(findobj('Tag','dispersion_filename_text'),'Visible','on','String',['Dispersion file: ' dispersfilename]);
elseif length(dispersfilename)>96
    set(findobj('Tag','dispersion_filename_text'),'Visible','on','String',['Dispersion file: ' dispersfilename(end-96:end)]);
end
delay_shift_curve=load (dispersfilename);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Loading of raw data, and plotting of loaded dispersion curve on top of raw data
if exist('filename')==0 || isempty(filename)==1
    errordlg('Load dataset first!')     %This only produces a box, but does not stop execution
    error('Load dataset first!')        %This does stop the execution
end
raw_data=load (filename);
xdata_raw=raw_data(:,1);

%Error checking
%Check if time points monotonically increase
if isequal(sort(xdata_raw),xdata_raw)==0
    errordlg('Time points not monotonically increasing. Check first column in data.')
    error('Time points not monotonically increasing. Check first column in data.')
end
%Check if time points in raw data correspond to time points in dispersion
%curve
time_point_check=sort(unique(delay_shift_curve));
for i=1:length(time_point_check)
    if isempty(find(xdata_raw==time_point_check(i)))==0
        errordlg('Time points in dispersion curve file do not correspond to time points in raw data.')
        error('Time points in dispersion curve file do not correspond to time points in raw data.')
    end
end

ydata_raw=raw_data(:,2:end);
wave_raw=1:size(ydata_raw,2);

%Plotting
%3D plot of raw data and dispersion curve
if isempty(findobj('Name','Loaded dispersion curve'))==0 %If figure exists already, delete it
    close ('Loaded dispersion curve');
end
dispersion_data_plot=figure;
set(dispersion_data_plot,'name','Loaded dispersion curve','Units','normalized','position',[0.02 0.05 0.97 0.8],'NumberTitle','off','Toolbar','figure');

surf(wave_raw,xdata_raw,ydata_raw(:,:))
shading interp
view([0 90])
axis tight;
hold on
plot(wave_raw,delay_shift_curve,'k');
title('Loaded raw data and dispersion curve','Interpreter','None');
xlabel('Pixel');
ylabel('Time');
set(dispersion_data_plot,'renderer','opengl') %For faster screen updates when rotating figure