%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%open_figs.m

function open_figs

[FigNames,Figs_Pathname] = uigetfile('*.fig','Select figures to open','MultiSelect','on');
cd (Figs_Pathname)

%Disable 'negative timepoints' warning if logarithmic time axis used. Is
%switched back on at end of this file
warning('off','MATLAB:Axes:NegativeDataInLogAxis')

if ischar(FigNames)==1
    open (FigNames);
elseif ischar(FigNames)==0
    nr_figs=size(FigNames,2);
    for fig_counter=1:nr_figs
        open(FigNames{fig_counter});
    end
    clear nr_figs fig_counter
end
clear FigNames Figs_Pathname

%Turn warning about negative timepoints back on again (see above)
warning('on','MATLAB:Axes:NegativeDataInLogAxis')