%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%plot_fit_prog_live_fun_lsqnonlin.m

function stop = plot_fit_prog_live_fun_lsqnonlin(x,optimValues,state)
global comps;
global Par_fix_switch Par_fix_time Par_fix_time_zero
global IRF Par_fix_IRF

% OPTIMPLOTX Plot current point at each iteration.
%
%   STOP = OPTIMPLOTX(X,OPTIMVALUES,STATE) plots the current point, X, as a
%   bar plot of its elements at the current iteration.
%
%   Example:
%   Create an options structure that will use OPTIMPLOTX
%   as the plot function
%       options = optimset('PlotFcns',@optimplotx);
%
%   Pass the options into an optimization problem to view the plot
%       fminbnd(@sin,3,10,options)

%   Copyright 2006 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $  $Date: 2006/05/19 20:17:10 $

stop = false;
switch state
    case 'iter'
        % Reshape if x is a matrix
        x = x(:);
        xLength = length(x);
        xlabelText = ['Number of variables: ',num2str(xLength)];

        % Display up to the first 100 values
        if length(x) > 100
            x = x(1:100);
            xlabelText = {xlabelText,'Showing only the first 100 variables'};
        end
        
        if optimValues.iteration == 0
            % The 'iter' case is  called during the zeroth iteration,
            % but it now has values that were empty during the 'init' case
            plotx = bar(x);
            if isequal(Par_fix_time,0)==1 
                if IRF(1)==0 || Par_fix_IRF==1
                    if Par_fix_time_zero==1
                        title(['Current Point (',num2str(comps),' rate constants)'],'interp','none');
                    elseif Par_fix_time_zero==0
                        title(['Current Point (',num2str(comps),' rate constants, time zero)'],'interp','none');
                    end
                elseif length(IRF)==2 && Par_fix_IRF==0
                    if Par_fix_time_zero==1
                        title(['Current Point (',num2str(comps),' rate constants, and IRF (FWHM, t0)).'],'interp','none');
                    elseif Par_fix_time_zero==0
                        title(['Current Point (',num2str(comps),' rate constants, time zero, and IRF (FWHM, t0)).'],'interp','none');
                    end
                end
            elseif isequal(Par_fix_time,0)==0
                if IRF(1)==0 || Par_fix_IRF==1
                    if Par_fix_time_zero==1
                        title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),')'],'interp','none');
                    elseif Par_fix_time_zero==0
                        title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),', and time zero)'],'interp','none');
                    end
                 elseif length(IRF)==2 && Par_fix_IRF==0
                     if Par_fix_time_zero==1
                         title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),'). Last two parameters are IRF (FWHM, t0)'],'interp','none');
                     elseif Par_fix_time_zero==0
                         title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),'), time zero, and last two parameters are IRF (FWHM, t0)'],'interp','none');
                     end
                end
            end
            ylabel('Current point value','interp','none');
            xlabel(xlabelText,'interp','none');
            set(plotx,'edgecolor','none')
            set(gca,'xlim',[0,1 + xLength])
            set(plotx,'Tag','optimplotx');
        else
            plotx = findobj(get(gca,'Children'),'Tag','optimplotx');
            set(plotx,'Ydata',x);
        end
end

