%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%plot_fit_prog_live_fun_pattern.m

function stop = plot_fit_prog_live_fun_pattern(optimvalues,flag)
global comps;
global Par_fix_time
global IRF Par_fix_IRF Par_fix_time_zero

%PSPLOTBESTX PlotFcn to plot best X value.
%   STOP = PSPLOTBESTX(OTIMVALUES,FLAG) where OPTIMVALUES is a structure
%   with the following fields:
%              x: current point X
%      iteration: iteration count
%           fval: function value
%       meshsize: current mesh size
%      funccount: number of function evaluations
%         method: method used in last iteration
%         TolFun: tolerance on function value in last iteration
%           TolX: tolerance on X value in last iteration
%
%   FLAG: Current state in which PlotFcn is called. Possible values are:
%           init: initialization state
%           iter: iteration state
%           done: final state
%
%   STOP: A boolean to stop the algorithm.
%
%   See also PATTERNSEARCH, GA, PSOPTIMSET.


%   Copyright 2003-2007 The MathWorks, Inc.
%   $Revision: 1.6.4.6 $  $Date: 2007/08/03 21:23:41 $

stop = false;
switch flag
    case 'init'
        set(gca,'xlimmode','manual','zlimmode','manual', ...
            'alimmode','manual')
        if isequal(Par_fix_time,0)==1
            if IRF(1)==0 || Par_fix_IRF==1
                if Par_fix_time_zero==1
                    title(['Current Point (',num2str(comps),' rate constants)'],'interp','none');
                elseif Par_fix_time_zero==0
                    title(['Current Point (',num2str(comps),' rate constants, time zero)'],'interp','none');
                end
            elseif length(IRF)==2 && Par_fix_IRF==0
                if Par_fix_time_zero==1
                    title(['Current Point (',num2str(comps),' rate constants, and IRF (FWHM, t0)).'],'interp','none');
                elseif Par_fix_time_zero==0
                    title(['Current Point (',num2str(comps),' rate constants, time zero, and IRF (FWHM, t0)).'],'interp','none');
                end
            end
        elseif isequal(Par_fix_time,0)==0
            if IRF(1)==0 || Par_fix_IRF==1
                if Par_fix_time_zero==1
                    title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),')'],'interp','none');
                elseif Par_fix_time_zero==0
                    title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),', and time zero)'],'interp','none');
                end
            elseif length(IRF)==2 && Par_fix_IRF==0
                if Par_fix_time_zero==1
                    title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),'). Last two parameters are IRF (FWHM, t0)'],'interp','none');
                elseif Par_fix_time_zero==0
                    title(['Current Point (',num2str(comps),' overall rate constants; of which these numbers are fixed: ',num2str(Par_fix_time),'), time zero, and last two parameters are IRF (FWHM, t0)'],'interp','none');
                end
            end
        end
        Xlength = numel(optimvalues.x);
        xlabel(['Number of variables (',num2str(Xlength),')'], ...
            'interp','none');
        ylabel('Current best point value','interp','none');
        plotBestX = bar(optimvalues.x(:));
        set(plotBestX,'Tag','psplotbestx');
        set(plotBestX,'edgecolor','none')
        set(gca,'xlim',[0,1 + Xlength])
    case 'iter'
        plotBestX = findobj(get(gca,'Children'),'Tag','psplotbestx');
        set(plotBestX,'Ydata',optimvalues.x(:))
end





