%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%plot_raw_data.m

function plot_raw_data
%Plotting of raw data. Called by loading of raw data.
%Data exploration is possible via data_explorer_plot, which let's the
%user click inside the raw data plot to visualise a slice through the data.
%Standard data file extension is .dat.

global filename; %called by plot_raw_data
global wave_raw xdata_raw ydata_raw; %called by data_explorer_plot (also 'filename' needed)

%If raw data plots are already made, delete them
if isempty(findobj('Name','Loaded_raw_data'))==0
    close Loaded_raw_data;
end
if isempty(findobj('Name','Explore raw data'))==0
    close ('Explore raw data');
end

%----Only plots raw data.
% Also invoked by pressing 'Fit'.

raw_data_plot=figure;
set(raw_data_plot,'name','Loaded_raw_data','Units','normalized','position',[0.02 0.05 0.97 0.8],'NumberTitle','off','Toolbar','figure');
lin_log=get(findobj('Tag','lin_log_toggle'),'Value');

%Disable 'negative timepoints' warning if logarithmic time axis used. Is
%switched back on at end of this file
warning('off','MATLAB:Axes:NegativeDataInLogAxis')

if strcmp(filename(end-2:end),'dsa')==1

    wave_raw_points=dlmread(filename,',',[17,0,17,0]);
    wave_raw=dlmread(filename,',',[18,0,18,wave_raw_points-1]);
    waverange=[1,120];
    time_raw_points=dlmread(filename,',',[13,0,13,0]);
    xdata_raw=dlmread(filename,',',[14,0,14,time_raw_points-1]);
    ydata_raw = csvread(filename,21,0,[21,0,wave_raw_points+20,time_raw_points-1]);
    dsa2dat_button=uicontrol(raw_data_plot,'Style','Pushbutton','String','Convert data','units','normalized','Position',[.02 .85 .06 .05],...
        'Callback','dsa2dat_try','TooltipString','Convert whole datafile to .dat file, which can be read in by main program and analysed.');
    dsa_wave_trace_button=uicontrol(raw_data_plot,'Style','Pushbutton','String','Save traces','units','normalized','Position',[.02 .79 .06 .05],...
        'Callback','dsa_wave_trace_try','TooltipString','Write 450nm, baseline corrected and time zero subtracted to datafile.');
    subplot(2,1,1)
    surf(wave_raw(waverange(1):waverange(2)),xdata_raw,ydata_raw(waverange(1):waverange(2),:)')
    axis tight
    xlabel('Pixel');
    ylabel('Time');
    if lin_log==0
        set(gca,'YScale','log');
    end
    subplot(2,1,2)
    %Timepoint subtraction
    for j=1:size(ydata_raw,2)
        ydata_manip(:,j)=ydata_raw(:,j)-ydata_raw(:,1);
    end
    %Wavelength subtraction
    for i=1:size(ydata_manip,1)
        ydata_manip(i,:)=ydata_manip(i,:)-ydata_manip(waverange(2),:);
    end
    %     plot(wave_raw(waverange(1):waverange(2)),ydata_manip(waverange(1):waverange(2),:))
    surf(wave_raw(waverange(1):waverange(2)),xdata_raw,ydata_manip(waverange(1):waverange(2),:)')
    title('Time zero and 700 nm subtracted.')
    ylabel('Time');
    xlabel('Pixel');
    if  lin_log==0
        set(gca,'YScale','log');
    end
    axis tight
    clear ydata_manip;
    subplot(2,1,1)
    title(['Datafile: ' filename],'Interpreter','None');    %The TEX Interpreter is switched off to prevent error message due to possible interpretation of forward slashes
    
    %-----New interactive figure with raw data and user-selected
    %spectrum/trace
    data_explore=figure;
    set(data_explore,'name','Explore raw data','Units','normalized','position',[0.02 0.05 0.97 0.8],'NumberTitle','off','Toolbar','figure');
    %Renderer setting below needed to prevent cross-hair from drawing over figure
    if lin_log==1
        set(data_explore,'renderer','zbuffer')
    end
    
    wave_raw=wave_raw(waverange(1):waverange(2)); %To synchronise with data format with .dat extension
    ydata_raw=ydata_raw(waverange(1):waverange(2),:)'; %Idem
        
    subplot(3,3,[1:2,4:5])
    pcolor(xdata_raw,wave_raw,ydata_raw(:,:)')
    colorbar
    shading interp
    axis tight;
    title(['Datafile: ' filename],'Interpreter','None');    %The TEX Interpreter is switched off to prevent error message due to possible interpretation of forward slashes
    ylabel('Pixel');
    xlabel('Time');
    if lin_log==0
        set(gca,'XScale','log');
    end
    set(gca,'YDir','reverse');
    set(data_explore,'WindowButtonDownFcn','data_explorer_plot'); %To interactively select datapoint, and plot its spectrum/time trace
    
    subplot(3,3,7:8)
    plot(xdata_raw,ydata_raw(:,1),'k')
    xlabel(['Time trace at pixel ',num2str(wave_raw(1))]);
    axis tight
    grid on
    if lin_log==0
        set(gca,'XScale','log');
    end
    subplot(3,3,[3,6])
    plot(wave_raw,ydata_raw(1,:),'k')
    xlabel(['Pixel spectrum at timepoint ',num2str(xdata_raw(1))]);
    axis tight
    grid on
    
elseif strcmp(filename(end-2:end),'dat')==1
    raw_data=load (filename);
    xdata_raw=raw_data(:,1);
    %Check if time points monotonically increase
    if isequal(sort(xdata_raw),xdata_raw)==0
        errordlg('Time points not monotonically increasing. Check first column in data.')
        error('Time points not monotonically increasing. Check first column in data.')
    end
        ydata_raw=raw_data(:,2:end);
    wave_raw=1:size(ydata_raw,2);
    
    %-----3D plot of raw data (raw_data_plot)-----
    surf(xdata_raw,wave_raw,ydata_raw(:,:)')
    axis tight;
    title(['Datafile: ' filename],'Interpreter','None');    %The TEX Interpreter is switched off to prevent error message due to possible interpretation of forward slashes
    xlabel('Time');
    ylabel('Pixel');
    if lin_log==0
        set(gca,'XScale','log');
    end
    set(raw_data_plot,'renderer','opengl')
    
    %-----New interactive figure with raw data and user-selected
    %spectrum/trace
    data_explore=figure;
    set(data_explore,'name','Explore raw data','Units','normalized','position',[0.02 0.05 0.97 0.8],'NumberTitle','off','Toolbar','figure');
    
    %Renderer setting below needed to prevent cross-hair from drawing over figure
    if lin_log==1
        set(data_explore,'renderer','zbuffer')
    end
    
    xdata_raw=raw_data(:,1);
    ydata_raw=raw_data(:,2:end);
    wave_raw=1:size(ydata_raw,2);
    
    subplot(3,3,[1:2,4:5])
    pcolor(xdata_raw,wave_raw,ydata_raw(:,:)')
    colorbar
    shading interp
    axis tight;
    title({'Click in surface plot to activate cross-hair, click again for slice selection',['Datafile: ' filename]},'Interpreter','None');    %The TEX Interpreter is switched off to prevent error message due to possible interpretation of forward slashes
    ylabel('Pixel');
    xlabel('Time');
    if lin_log==0
        set(gca,'XScale','log');
    end
    set(gca,'YDir','reverse');
    set(data_explore,'WindowButtonDownFcn','data_explorer_plot'); %To interactively select datapoint, and plot its spectrum/time trace
    
    subplot(3,3,7:8)
    plot(xdata_raw,ydata_raw(:,1),'k')
    xlabel(['Time trace at pixel ',num2str(wave_raw(1))]);
    axis tight
    grid on
    if lin_log==0
        set(gca,'XScale','log');
    end
    subplot(3,3,[3,6])
    plot(wave_raw,ydata_raw(1,:),'k')
    xlabel(['Pixel spectrum at timepoint ',num2str(xdata_raw(1))]);
    axis tight
    grid on
end

%Turn warning about negative timepoints back on again (see above)
warning('on','MATLAB:Axes:NegativeDataInLogAxis')