%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%recall_settings.m

function recall_settings

global filename analysis model calibfilename nr_svd_comps SVDcontrib_switch time_choice 
global start_par_OD_offset start_par_time_zero Alg_accuracy_switch IRF Dispers_order dispersfilename
global Par_fix_switch Par_fix_time Par_fix_time_zero Par_fix_OD_offset Par_fix_IRF Par_fix_spectra_matrix 
global time_shift wave_shift time_limits wave_limits time_divider wave_divider sub_timepoint sub_wavelength 
global axis_switch plot_residuals plot_fit_prog_live Error_switch_nonlin Error_switch_lin_spectra 
global wave_digits plot_wave_divider

[loadFileName,loadPathName]=uigetfile('*.inp','Select file');
load ('-mat',strcat(loadPathName,loadFileName));

%PANEL 1: Information panel
if length(filename)<67
    set(findobj('Tag','load_data_text'),'Visible','on','String',['    Datafile file: ' filename]);
elseif length(filename)>66
    set(findobj('Tag','load_data_text'),'Visible','on','String',['    Datafile file: ' filename(end-66:end)]);
end
if exist ('dispersfilename','var')==0
    dispersfilename='';
elseif exist ('dispersfilename','var')==1
    if length(dispersfilename)<67
        set(findobj('Tag','dispersion_filename_text'),'Visible','on','String',['Dispersion file: ' dispersfilename]);
    elseif length(dispersfilename)>66
        set(findobj('Tag','dispersion_filename_text'),'Visible','on','String',['Dispersion file: ' dispersfilename(end-66:end)]);
    end
end    
    
    
%PANEL 2: Model selection
%NB. 'analysis' already defined in load_model
if analysis==1
    button_model=findobj('String','Parallel');
elseif analysis==2
    button_model=findobj('String','Sequential');
elseif analysis==3
    button_model=findobj('String','Target model');
    set(findobj('Tag','model3_fix_toggle'),'visible','on','Value',1)
end
set(findobj('Tag','model_sel_panel'),'SelectedObject',button_model)
set(findobj('Tag','load_model_text'),'Visible','on','String',['       Model file: ' model]);

%PANEL 3: Data selection
if exist ('calibfilename','var')==0
    calibfilename='';
elseif exist ('calibfilename','var')==1
    if length(calibfilename)<67
        set(findobj('Tag','calibfilename_text'),'Visible','on','String',['Calibration file: ' calibfilename]);
    elseif length(calibfilename)>66
        set(findobj('Tag','calibfilename_text'),'Visible','on','String',['Calibration file: ' calibfilename(end-66:end)]);
    end
end

if nr_svd_comps==0
    button_data=findobj('String','All data');
    set(findobj('Tag','nr_SVD_comps_text_box'),'Visible','off');
    set(findobj('Tag','SVD_contrib_toggle'),'Visible','off');
    set(findobj('Tag','nr_SVD_comps_box'),'Visible','off');
elseif nr_svd_comps>0
    button_data=findobj('String','SVD');
    set(findobj('Tag','nr_SVD_comps_text_box'),'Visible','on');
    set(findobj('Tag','SVD_contrib_toggle'),'Value',SVDcontrib_switch,'Visible','on');
    set(findobj('Tag','nr_SVD_comps_box'),'String',num2str(nr_svd_comps),'Visible','on');
end
set(findobj('Tag','data_sel_panel'),'SelectedObject',button_data)

%PANEL 4: Fitting parameters
set(findobj('Tag','time_choice_box'),'String',num2str(time_choice));
set(findobj('Tag','time_zero_box'),'String',num2str(start_par_OD_offset));
set(findobj('Tag','OD_offset_box'),'String',num2str(start_par_time_zero));
if exist('Alg_accuracy')==0
    Alg_accuracy=0;
    Alg_choice=0;
    Alg_interpol=1;
    Dispers_pars=0;
    Disp_wave_range1=0;
    Disp_wave_range2=0;
    Disp_time_range1=0;
    Disp_time_range2=0;
    Par_fix_disp=0;
    time_weight=0;
    wave_weight=0;
    lin_log=0;
end
set(findobj('Tag','Alg_accuracy_toggle'),'Value',Alg_accuracy);
set(findobj('Tag','Alg_choice_toggle'),'Value',Alg_choice);
set(findobj('Tag','Alg_interpol_box'),'String',num2str(Alg_interpol));
set(findobj('Tag','IRF_box'),'String',num2str(IRF));
set(findobj('Tag','Dispers_box'),'String',num2str(Dispers_pars));
set(findobj('Tag','dispersion_correction_toggle'),'Value',dispersion_correction);
set(findobj('Tag','Par_fix_disp_toggle'),'Value',Par_fix_disp);
set(findobj('Tag','Disp_panel'),'Visible','off');
set(findobj('Tag','Alg_accuracy_toggle'),'Visible','off');
set(findobj('Tag','Alg_choice_toggle'),'Visible','off');
set(findobj('Tag','Alg_interpol_text'),'Visible','off');
set(findobj('Tag','Alg_interpol_box'),'Visible','off');
set(findobj('Tag','time_zero_text'),'Visible','on');
set(findobj('Tag','time_zero_box'),'Visible','on');
set(findobj('Tag','OD_offset_text'),'Visible','on');
set(findobj('Tag','OD_offset_box'),'Visible','on');
set(findobj('Tag','IRF_text'),'Visible','on');
set(findobj('Tag','IRF_box'),'Visible','on');
set(findobj('Tag','par_fix_switch_toggle'),'Visible','on');

% %Constraints
set(findobj('Tag','par_fix_switch_toggle'),'Value',1);
if Par_fix_switch==1;
    set(findobj('Tag','Par_fix_time_text'),'Visible','on');
    set(findobj('Tag','Par_fix_time_box'),'String',num2str(Par_fix_time),'Visible','on');
    set(findobj('Tag','Par_fix_time_zero_toggle'),'Value',Par_fix_time_zero,'Visible','on');
    set(findobj('Tag','Par_fix_OD_offset_toggle'),'Value',Par_fix_OD_offset,'Visible','on');
    set(findobj('Tag','Par_fix_IRF_toggle'),'Value',Par_fix_IRF,'Visible','on');
    set(findobj('Tag','Par_fix_spectra_matrix_text'),'Visible','on');
    set(findobj('Tag','Par_fix_spectra_matrix_box'),'String',num2str(Par_fix_spectra_matrix),'Visible','on');
    set(findobj('Tag','fit_pars_1'),'value',1)
elseif Par_fix_switch==0
    set(findobj('Tag','Par_fix_time_text'),'Visible','off');
    set(findobj('Tag','Par_fix_time_box'),'String',Par_fix_time,'Visible','off');
    set(findobj('Tag','Par_fix_time_zero_toggle'),'Value',Par_fix_time_zero,'Visible','off');
    set(findobj('Tag','Par_fix_OD_offset_toggle'),'Value',Par_fix_OD_offset,'Visible','off');
    set(findobj('Tag','Par_fix_IRF_toggle'),'Value',Par_fix_IRF,'Visible','off');
    set(findobj('Tag','Par_fix_spectra_matrix_text'),'Visible','off');
    set(findobj('Tag','Par_fix_spectra_matrix_box'),'String',num2str(Par_fix_spectra_matrix),'Visible','off');
    set(findobj('Tag','fit_pars_1'),'value',1)
end
 
% %*****PANEL 5: Data manipulation*****
set(findobj('Tag','time_shift_box'),'String',num2str(time_shift));
set(findobj('Tag','wave_shift_box'),'String',num2str(wave_shift));
set(findobj('Tag','time_lim_box1'),'String',num2str(time_limits(1)));
set(findobj('Tag','time_lim_box2'),'String',num2str(time_limits(2)));
set(findobj('Tag','wave_lim_box1'),'String',num2str(wave_limits(1)));
set(findobj('Tag','wave_lim_box2'),'String',num2str(wave_limits(2)));
set(findobj('Tag','time_divider_box'),'String',num2str(time_divider));
set(findobj('Tag','wave_divider_box'),'String',num2str(wave_divider));
set(findobj('Tag','time_subtract_box'),'String',num2str(sub_timepoint));
set(findobj('Tag','wave_subtract_box'),'String',num2str(sub_wavelength));
set(findobj('Tag','time_weight_box'),'String',num2str(time_weight));
set(findobj('Tag','wave_weight_box'),'String',num2str(wave_weight));

% %*****PANEL 6: Plotting options*****
set(findobj('Tag','axis_switch_toggle'),'Value',axis_switch);
set(findobj('Tag','plot_residuals_toggle'),'Value',plot_residuals);
set(findobj('Tag','plot_fit_prog_live_toggle'),'Value',plot_fit_prog_live);
set(findobj('Tag','wave_digits_box'),'String',wave_digits);
set(findobj('Tag','lin_log_toggle'),'Value',lin_log);
set(findobj('Tag','plot_wave_divider_box'),'String',num2str(plot_wave_divider));

% %*****PANEL 7: Error estimation*****
set(findobj('Tag','Error_switch_nonlin_toggle'),'Value',Error_switch_nonlin);
set(findobj('Tag','Error_switch_lin_spectra_toggle'),'Value',Error_switch_lin_spectra);
 
% [saveFileName,savePathName]=uiputfile('*.dat', 'Save parameter file');
% save (strcat(savePathName,saveFileName))