%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%save_settings.m

function save_settings
%Save all gui parameters to separate file (*.inp) for reloading

%Defined in fit_data
global filename analysis model nr_svd_comps SVDcontrib_switch time_choice obj
global start_par_OD_offset start_par_time_zero Alg_accuracy Alg_switch IRF Par_fix_disp
global wave_digits plot_wave_divider
global Par_fix_switch Par_fix_time time_fix_counter Par_fix_time_zero 
global Par_fix_OD_offset Par_fix_IRF Par_fix_spectra_matrix  
global time_shift wave_shift time_limits wave_limits time_divider 
global wave_divider sub_timepoint sub_wavelength 
global axis_switch plot_residuals plot_fit_prog_live wave_digits 
global Error_switch_nonlin Error_switch_lin_spectra 

%Defined in load_calibration
global calibfilename 

%Defined in load_dispersion
global dispersfilename

%Defined in globfit_bio_gui
global opt_pars opt_times 

%#######################
%Select where to save your input file
[saveFileName,savePathName]=uiputfile('*.inp', 'Save parameter file');
if savePathName==0
    error('Saving settings file aborted by user');
end

%PANEL 2: Model selection
if get(findobj('Tag','model1'),'Value')==1
    analysis=1;
elseif get(findobj('Tag','model2'),'Value')==1
    analysis=2;
elseif get(findobj('Tag','model3'),'Value')==1
    analysis=3;
end

%PANEL 3: Data selection
%NB. 'calibfilename' already defined in 'load_calibration'
nr_svd_comps=str2double(get(findobj('Tag','nr_SVD_comps_box'),'String'));
SVDcontrib_switch=get(findobj('Tag','SVD_contrib_toggle'),'Value');    

%PANEL 4: Fitting parameters
%NB. 'time_choice' already defined in 'load_model'
%NB. 'comps' already defined in 'load_model'
time_choice=str2num(get(findobj('Tag','time_choice_box'),'String'));
start_par_OD_offset=str2double(get(findobj('Tag','time_zero_box'),'String'));
start_par_time_zero=str2double(get(findobj('Tag','OD_offset_box'),'String'));
Alg_accuracy=get(findobj('Tag','Alg_accuracy_toggle'),'Value');
Alg_choice=get(findobj('Tag','Alg_choice_toggle'),'Value');
Alg_interpol=str2num(get(findobj('Tag','Alg_interpol_box'),'String'));
IRF=str2num(get(findobj('Tag','IRF_box'),'String'));
Dispers_pars=str2num(get(findobj('Tag','Dispers_box'),'String'));
dispersion_correction=get(findobj('Tag','dispersion_correction_toggle'),'Value');

%Constraints
Par_fix_switch=get(findobj('Tag','par_fix_switch_toggle'),'Value');
Par_fix_time=str2num(get(findobj('Tag','Par_fix_time_box'),'String'));
Par_fix_time_zero=get(findobj('Tag','Par_fix_time_zero_toggle'),'Value');
Par_fix_OD_offset=get(findobj('Tag','Par_fix_OD_offset_toggle'),'Value');
Par_fix_IRF=get(findobj('Tag','Par_fix_IRF_toggle'),'Value');
Par_fix_disp=get(findobj('Tag','Par_fix_disp_toggle'),'Value');
Par_fix_spectra_matrix=str2num(get(findobj('Tag','Par_fix_spectra_matrix_box'),'String'));

%*****PANEL 5: Data manipulation*****
time_shift=get(findobj('Tag','time_shift_box'),'String');
wave_shift=str2double(get(findobj('Tag','wave_shift_box'),'String'));
time_limits(1)=str2double(get(findobj('Tag','time_lim_box1'),'String'));
time_limits(2)=str2double(get(findobj('Tag','time_lim_box2'),'String'));
wave_limits(1)=str2double(get(findobj('Tag','wave_lim_box1'),'String'));
wave_limits(2)=str2double(get(findobj('Tag','wave_lim_box2'),'String'));
time_divider=str2double(get(findobj('Tag','time_divider_box'),'String'));
wave_divider=str2double(get(findobj('Tag','wave_divider_box'),'String'));
sub_timepoint=str2num(get(findobj('Tag','time_subtract_box'),'String'));
sub_wavelength=str2num(get(findobj('Tag','wave_subtract_box'),'String'));
time_weight=str2num(get(findobj('Tag','time_weight_box'),'String'));
wave_weight=str2num(get(findobj('Tag','wave_weight_box'),'String'));

%*****PANEL 6: Plotting options*****
axis_switch=get(findobj('Tag','axis_switch_toggle'),'Value');
plot_residuals=get(findobj('Tag','plot_residuals_toggle'),'Value');
plot_fit_prog_live=get(findobj('Tag','plot_fit_prog_live_toggle'),'Value');
wave_digits=get(findobj('Tag','wave_digits_box'),'String');
lin_log=get(findobj('Tag','lin_log_toggle'),'Value');
plot_wave_divider=str2num(get(findobj('Tag','plot_wave_divider_box'),'String'));

%*****PANEL 7: Error estimation*****
Error_switch_nonlin=get(findobj('Tag','Error_switch_nonlin_toggle'),'Value');
Error_switch_lin_spectra=get(findobj('Tag','Error_switch_lin_spectra_toggle'),'Value');

cd (savePathName);
save (saveFileName);
clear saveFileName savePathName;