
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*$Id: checkgas.c 1356 2008-08-18 13:41:15Z  $*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <signal.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"
#include "pore_routines.h"
#include "props.h"
#include "rand_step.h"
#include "gaussdev.h"
#include "umat_histo.h"
#include "find_max.h"
#define STARTSTEP 11750
#define ENDSTEP 11760
CA_FLOAT checkgas (BB_struct * bp, int callflag)
{
  static int callnum = 1;
  CA_FLOAT pore_nmols = 0, diff_gas, ctot = 0, tot_gas = 0, dumb, change;
  CA_FLOAT init_gas = (bp->ncsb * bp->ntsb * bp->vol_c * bp->mprops.gasprops.Cinit);
  PORE_str *pl;
  int sbnum, i;

  if (bp->step < STARTSTEP)
    return (0);
  for (sbnum = 0; sbnum < bp->ntsb; sbnum++) {
    pl = bp->sb[sbnum]->porelist;

    find_max_conc (bp, bp->c_sol_values, sbnum);
    /* add up the n-mols in the pores */
    for (i = 0; i < bp->sb[sbnum]->Npores; i++) {
      switch (pl[i].State) {
      case PORE_OFF:           /*fallthrough */
      case PORE_NONE:          /*fallthrough */
      case PORE_LATENT:
      case NOT_CASTING:
        /* do nothing */
        break;

      case PORE_SPHERE:        /*fallthrough */
      case PORE_TUBE:
      case PORE_FROZEN:
      case PORE_MULTI:
        pore_nmols += pl[i].NmolsH;
        break;

      default:
        fprintf (stderr, "Output_ex: Pore state in hyperspace %i\n", pl[i].State);
        break;
      }                         /* end of pore switch */
    }                           /* end of looping through pores */
    ctot += bp->c_sol_values->Ctot;
  }                             /* end of sb loop */
  tot_gas = (bp->vol_c) * (ctot) + (pore_nmols * 2);
  diff_gas = ABS ((tot_gas - init_gas) / init_gas);
  if (bp->step >= STARTSTEP)
    fprintf (stderr, "CHECKGAS:bstep, callflag,callnum,tot_gas,%i,%i,%i,%.10g\n", bp->step, callflag, callnum, tot_gas);
  if (callnum == 199) {
    int dumb;

    dumb = 0;
  }
  callnum++;
  if (bp->step == ENDSTEP)
    raise (SIGUSR1);
  return (diff_gas);
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *checkgas_c ()
{
  static char const rcsid[] = "$Id: checkgas.c 1356 2008-08-18 13:41:15Z  $";

  return (rcsid);
}
