
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

#include <stdio.h>
#include "machine.h"
#include <math.h>
/**  \todo  figure out how to completely eliminate the need for this subroutine -- general - maybe done already?*/

int getxyz (int cellnum, int *nc, int *Cell)
{
/* cellnum = cell index to find the x,y,z for */
/* nc = array[3] of number of cells in x,y,z of block */
/* Cell = array[3] to put the calculated cell x,y,z into */

  int errors = 0;
  int cellx, celly, cellz;
  int nxny, nxnynz, ncx, ncy;

  /* double or else round-off is too big for 1/3 */
  double tmp1, tmp2, tmp3;

  ncx = *nc++;
  ncy = *nc++;
  nxny = ncx * ncy;
  nxnynz = nxny * (*nc);

  if (cellnum > nxnynz) {
    errors++;
  } else {
    tmp1 = (double) cellnum / (double) nxny;
    cellz = (int) (floor (tmp1));
    tmp2 = (double) (cellnum - cellz * nxny);
    tmp3 = tmp2 / (double) ncx;
    celly = (int) (floor (tmp3));
    cellx = cellnum - cellz * nxny - celly * ncx;

    *Cell++ = cellx;
    *Cell++ = celly;
    *Cell = cellz;
  }
  return (errors);
}

#ifdef TESTXYZ
void main ()
{
  int nc[3], Cell[3];
  int i;
  int cellnum, testnum;
  FILE *output;
  int errors;

  printf ("input system size:\n");
  for (i = 0; i < 3; i++) {
    scanf ("%i", &(nc[i]));
  }
  printf ("system size %i %i %i\n", nc[0], nc[1], nc[2]);

  while (1) {
    printf ("INput a cell number:");
    scanf ("%i", &cellnum);
    errors = getxyz (cellnum, nc, Cell);
    if (errors) {
      printf ("Error: cell %i out of range.\n", cellnum);
      break;
    } else {
      for (i = 0; i < 3; i++) {
        printf ("%i ", Cell[i]);
      }
      printf ("\n");
    }
  }
  output = fopen ("Cell.csv", "w");
  for (cellnum = 0; cellnum < nc[0] * nc[1] * nc[2]; cellnum++) {
    errors = getxyz (cellnum, nc, Cell);
    testnum = Cell[0] + Cell[1] * nc[0] + Cell[2] * nc[0] * nc[1];
    if (testnum != cellnum) {
      fprintf (output, "%i,", cellnum);
      for (i = 0; i < 3; i++) {
        fprintf (output, "%i,", Cell[i]);
      }
      fprintf (output, "\n");
    }
  }
  fclose (output);
}

#endif /*TESTXYZ*/
/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_getxyz_c ()
{
  static char const rcsid[] = "$Id: getxyz.c 1339 2008-07-23 13:58:29Z  $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
