
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*$Id: write_block_values.c 1339 2008-07-23 13:58:29Z  $*/
/* AUTOGENERATED write structure routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"
/* start of structure blocksize_str */
void write_blocksize_str_values (FILE * fp, struct blocksize_str *sp)
{
  int i;

  fprintf (fp, "\n# blocksize_str STRUCTURE VALUES *****\n");
  fprintf (fp, "fsize %i \n", sp->fsize);
  fprintf (fp, "csize %i \n", sp->csize);
  fprintf (fp, "bbsize %i \n", sp->bbsize);
  fprintf (fp, "sbsize %i \n", sp->sbsize);
  fprintf (fp, "gsize %i \n", sp->gsize);
  fprintf (fp, "psize %i \n", sp->psize);
  fprintf (fp, "PORE_size %i \n", sp->PORE_size);
  fprintf (fp, "pcnsize %i \n", sp->pcnsize);
  fprintf (fp, "pclsize %i \n", sp->pclsize);
}

/* End of structure bsize */
/* start of structure values */
void write_values_values (FILE * fp, struct values *sp)
{
  int i;

  fprintf (fp, "\n# values STRUCTURE VALUES *****\n");
  fprintf (fp, "disp_max %g \n", sp->disp_max);
  fprintf (fp, "part_coef %g \n", sp->part_coef);
  fprintf (fp, "CLmin %g \n", sp->CLmin);
  fprintf (fp, "CLmax %g \n", sp->CLmax);
  fprintf (fp, "Cmin %g \n", sp->Cmin);
  fprintf (fp, "Cmax %g \n", sp->Cmax);
  fprintf (fp, "Ctot %g \n", sp->Ctot);
  fprintf (fp, "SSmax %g \n", sp->SSmax);
  fprintf (fp, "SSmin %g \n", sp->SSmin);
  fprintf (fp, "SATmax %g \n", sp->SATmax);
}

/* End of structure Value_struct */
/* start of structure subblock */
void write_subblock_values (FILE * fp, struct subblock *sp)
{
  int i;

  fprintf (fp, "\n# subblock STRUCTURE VALUES *****\n");
  fprintf (fp, "Npores %i \n", sp->Npores);
  fprintf (fp, "code %i \n", sp->code);
  fprintf (fp, "done %i \n", sp->done);
  fprintf (fp, "ncsolid %i \n", sp->ncsolid);
  fprintf (fp, "ngr %i \n", sp->ngr);
  fprintf (fp, "nouts %i \n", sp->nouts);
  fprintf (fp, "nucnum %i \n", sp->nucnum);
  fprintf (fp, "nmould %i \n", sp->nmould);
  fprintf (fp, "num %i \n", sp->num);
  fprintf (fp, "open %i \n", sp->open);
  fprintf (fp, "sb_npores %i \n", sp->sb_npores);
  fprintf (fp, "orig_sb ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %g ", sp->orig_sb[i]);
  }
  fprintf (fp, " \n");
}

/* End of structure SB_struct */
/* start of structure bigblock */
void write_bigblock_values (FILE * fp, struct bigblock *sp)
{
  int i;

  fprintf (fp, "\n# bigblock STRUCTURE VALUES *****\n");
  fprintf (fp, "header ");
  for (i = 0; i < 256; i++) {
  }
  fprintf (fp, " \n");
  fprintf (fp, "CR %g \n", sp->CR);
  fprintf (fp, "Cinit %g \n", sp->Cinit);
  fprintf (fp, "CinitB %g \n", sp->CinitB);
  fprintf (fp, "Tinit %g \n", sp->Tinit);
  fprintf (fp, "Cbdy_alloy %g \n", sp->Cbdy_alloy);
  fprintf (fp, "Cbdy_gas %g \n", sp->Cbdy_gas);
  fprintf (fp, "area_bb %g \n", sp->area_bb);
  fprintf (fp, "autofin_time %g \n", sp->autofin_time);
  fprintf (fp, "delt %g \n", sp->delt);
  fprintf (fp, "fs_active %g \n", sp->fs_active);
  fprintf (fp, "fsgrow %g \n", sp->fsgrow);
  fprintf (fp, "grad_slope %g \n", sp->grad_slope);
  fprintf (fp, "gradient %g \n", sp->gradient);
  fprintf (fp, "iso_coef1 %g \n", sp->iso_coef1);
  fprintf (fp, "iso_coef2 %g \n", sp->iso_coef2);
  fprintf (fp, "oct_factor %g \n", sp->oct_factor);
  fprintf (fp, "orig_bb ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %g ", sp->orig_bb[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "finish_time %g \n", sp->finish_time);
  fprintf (fp, "sim_time %g \n", sp->sim_time);
  fprintf (fp, "this_temp %g \n", sp->this_temp);
  fprintf (fp, "size_bb ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %g ", sp->size_bb[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "size_c ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %g ", sp->size_c[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "velocity %g \n", sp->velocity);
  fprintf (fp, "vol_bb %g \n", sp->vol_bb);
  fprintf (fp, "vol_c %g \n", sp->vol_c);
  fprintf (fp, "vol_sb %g \n", sp->vol_sb);
  fprintf (fp, "window_disp %g \n", sp->window_disp);
  fprintf (fp, "window_velo %g \n", sp->window_velo);
  fprintf (fp, "yinv %g \n", sp->yinv);
  fprintf (fp, "auto_fin %i \n", sp->auto_fin);
  fprintf (fp, "bb_npores %i \n", sp->bb_npores);
  fprintf (fp, "cell_option %i \n", sp->cell_option);
  fprintf (fp, "dfs_cap %i \n", sp->dfs_cap);
  fprintf (fp, "dfs_err %i \n", sp->dfs_err);
  fprintf (fp, "dfs_warn %i \n", sp->dfs_warn);
  fprintf (fp, "dim %i \n", sp->dim);
  fprintf (fp, "extrafs_cap %i \n", sp->extrafs_cap);
  fprintf (fp, "first_micro %i \n", sp->first_micro);
  fprintf (fp, "last_micro %i \n", sp->last_micro);
  fprintf (fp, "header_size %i \n", sp->header_size);
  fprintf (fp, "nbeut %i \n", sp->nbeut);
  fprintf (fp, "n_a_sb %i \n", sp->n_a_sb);
  fprintf (fp, "nc ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %i ", sp->nc[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "ncsb %i \n", sp->ncsb);
  fprintf (fp, "nsb ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %i ", sp->nsb[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "nzones ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %i ", sp->nzones[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "nsteps %i \n", sp->nsteps);
  fprintf (fp, "nteut %i \n", sp->nteut);
  fprintf (fp, "ntsb %i \n", sp->ntsb);
  fprintf (fp, "pore_err %i \n", sp->pore_err);
  fprintf (fp, "realtime %i \n", sp->realtime);
  fprintf (fp, "scr_dump_num %i \n", sp->scr_dump_num);
  fprintf (fp, "step %i \n", sp->step);
  fprintf (fp, "tnc ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %i ", sp->tnc[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "total_cell_number %i \n", sp->total_cell_number);
  fprintf (fp, "tailer ");
  for (i = 0; i < 256; i++) {
  }
  fprintf (fp, " \n");
}

/* End of structure BB_struct */
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_block_values_c ()
{
  static char const rcsid[] = "$Id: write_block_values.c 1339 2008-07-23 13:58:29Z  $";

  return (rcsid);
}
