
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

#include "machine.h"
#include <stdio.h>
#include <math.h>
/*******************************************/
/*******************************************/
/*******************************************/
/*******************************************/
/* Functions for the nuc-function table    */
/*******************************************/
/* These functions generate the desired    */
/* distribution of N as a function of U    */
/* using three input parameters.           */
/*******************************************/
/*******************************************/
CA_FLOAT nuc_func_norm (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = p2 * 1 / (p1 * SQRT (2.0 * 3.14159)) * EXP (-((Unuc - p3) * (Unuc - p3)) / (2 * p1 * p1));
  return (result);
}

CA_FLOAT nuc_func_pow (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc > p1) ? p2 * POW ((Unuc - p1), p3) : 0;
  return (result);
}

CA_FLOAT nuc_func_square (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc > p1) ? p2 * (Unuc - p1) * (Unuc - p1) : 0;
  return (result);
}

CA_FLOAT nuc_func_delta (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc == p3) ? p2 : 0;
  return (result);
}

CA_FLOAT nuc_func_step (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc > p3 && Unuc < p1 + p3) ? p2 : 0;
  return (result);
}

CA_FLOAT nuc_func_user (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

/*******************************************/
/* Set result equal to a three parameter   */
/* function of Unuc to generate a distribu */
/* -tion of nuclation effectiveness        */
/*******************************************/
  result = 0;
/*         result = (Unuc > p1 && Unuc < p1+p3 )? p2:0;*/
  fprintf (stderr, "nuc_func_user: ERROR: function not defined!");
  exit (0);
  return (result);
}

/*******************************************/
/* Classical Nucleation Function of U,Tund */
/*******************************************/
CA_FLOAT nuc_function (CA_FLOAT Tund, CA_FLOAT Unuc)
{

  CA_FLOAT result;

  if (Tund <= 0)
    result = 0;
  else
    result = K_ONE * EXP (-Unuc / (Tund * Tund));
  return (result);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_nuc_functions_c ()
{
  static char const rcsid[] = "$Id: nuc_functions.c 1339 2008-07-23 13:58:29Z  $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
