
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*$Id: solprops_reader.c 1339 2008-07-23 13:58:29Z  $*/
/* AUTOGENERATED structure input routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "machine.h"
#include "solprops.h"
/*TO DO: MANUALLY ADD strings or other structures not implemented */
/* start of structure solprops */
static int tp_flag = 0;
extern void olderror(char * text, const char * callfunc);

#ifdef JUNK
static int tp_flag = 0, ce_flag = 0;
void calc_solprops_values (struct solprops *Struct_Ptr);
#endif

void input_solprops_values (char *filename, struct solprops *Struct_Ptr)
{
  int i;
  char *line;
  char *token;
  FILE *fp;
  char *sep;
  int error;
  int rflag = 0;
  line = (char *) calloc (MAX_STRING_LEN, sizeof (char));
  sep = strdup (" ,;\t\n\r");
  tp_flag = 0;

  printf ("solprops reader: Reading solute component %i from  %s\n", Struct_Ptr->my_num, filename);
   /*********************************************************/
  /* Open the control file                                 */
   /*********************************************************/
  if ((fp = fopen (filename, "r")) == NULL) {
    fprintf (stderr, "ERROR: solprops reader: can't open input file [%s]\n", filename);
    return;
  }

  while (fgets (line, MAX_STRING_LEN, fp) != NULL) {
    /* ignore comment and blank lines */
    if (line[0] == '%' || line[0] == '#' || (token = strtok (line, sep)) == NULL) {
      continue;
    } else if (strcasecmp (token, "my_name") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        snprintf(Struct_Ptr->my_name,32,token);
      }
    } else if (strcasecmp (token, "my_type") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->my_type = atoi (token);
      }
    } else if (strcasecmp (token, "Cinit") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Cinit = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "Dliq") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Dliq = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "Dsol0") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Dsol[0] = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "Dsol1") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Dsol[1] = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "Dsol2") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Dsol[2] = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "Dsol3") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Dsol[3] = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "Dsol4") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Dsol[4] = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "QaLiq") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->QaLiq = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "DoLiq") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->DoLiq = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "QaSol0") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->QaSol[0] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "DoSol0") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->DoSol[0] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "QaSol1") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->QaSol[1] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "DoSol1") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->DoSol[1] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "QaSol2") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->QaSol[2] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "DoSol2") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->DoSol[2] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "QaSol3") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->QaSol[3] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "DoSol3") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->DoSol[3] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "QaSol4") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->QaSol[4] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "DoSol4") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->DoSol[4] = (CA_FLOAT) atof (token);
      }

      /* Mould_Source  type of source */
      /* 0 == none , skip mould source in diffusion routine */
    } else if (strcasecmp (token, "mould_src") == 0) {
      if ((token = strtok (NULL, sep)) != NULL)
        Struct_Ptr->mould_src = (SrcFn_T) atoi (token);
    } else if (strcasecmp (token, "mould_source_value") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->mould_source_value = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "mould_src_pert") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->mould_src_pert = atoi (token);
      }
    } else if (strcasecmp (token, "part_coef0") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->part_coef[0] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "part_coef1") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->part_coef[1] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "Cs_stoechio") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->cs_stoechio = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "part_coef2") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->part_coef[2] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "part_coef3") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->part_coef[3] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "part_coef4") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->part_coef[4] = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "c_eut") == 0) {
        olderror(token,__func__);
    /*
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->c_eut = (CA_FLOAT) atof (token);
        ce_flag = 1;
      }
    */
    } else if (strcasecmp (token, "T_eut") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->T_eut = (CA_FLOAT) atof (token);
      }
/*    } else if (strcasecmp (token, "T_pure") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->T_pure = (CA_FLOAT) atof (token);
        tp_flag = 1;
      }*/
    } else if (strcasecmp (token, "Fs_eut") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->Fs_eut = (CA_FLOAT) atof (token);
      }

    } else if (strcasecmp (token, "m_solute0") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->m_solute[0] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "m_solute1") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->m_solute[1] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "m_solute2") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->m_solute[2] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "m_solute3") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->m_solute[3] = (CA_FLOAT) atof (token);
      }
    } else if (strcasecmp (token, "m_solute4") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->m_solute[4] = (CA_FLOAT) atof (token);
      }


    } else if (strcasecmp (token, "surf_tens_coef") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->surf_tens_coef = (CA_FLOAT) atof (token);
      }

   } else if (strcasecmp (token, "coef_doutre") == 0) {
      if ((token = strtok (NULL, sep)) != NULL) {
        Struct_Ptr->coef_doutre = (CA_FLOAT) atof (token);
      }
   }
  }
  free (line);
  fclose (fp);
  #ifdef JUNK
  /* moved to readmat.c */
  calc_solprops_values (Struct_Ptr);
  #endif
}

#ifdef JUNK
/* calculate the const properties not input , from the input quantities */
void calc_solprops_values (struct solprops *Struct_Ptr)
{
  Struct_Ptr->km = (1 - Struct_Ptr->part_coef);
  Struct_Ptr->kminv = 1 / (Struct_Ptr->km);
  if (Struct_Ptr->m_solute == 0)
    Struct_Ptr->m_inv_solute == 0;
  else
    Struct_Ptr->m_inv_solute = 1 / (Struct_Ptr->m_solute);
  fprintf (stderr, "\n\nNOTE: Linear Binary Phase Diagram: Calculating...\n");
  if (ce_flag && tp_flag) {
    fprintf (stderr, "ERROR:CALC_SOLPROPS_VALUES: Sorry, cannot override both liquidus slope and liquidus.\n");
    fprintf (stderr, "Please rewrite calc_solprops_values if this is what you need.\n");
    exit (0);
  }

  if (tp_flag == 1) {
    Struct_Ptr->T_liq = Struct_Ptr->T_pure + (Struct_Ptr->m_solute) * (Struct_Ptr->Cinit);
    fprintf (stderr, "T_pure specified, OVERRIDING liquidus\n");
    fprintf (stderr, "Liquidus Temperature T_liq = %.6g\n", Struct_Ptr->T_liq);
  } else {
    Struct_Ptr->T_pure = Struct_Ptr->T_liq - (Struct_Ptr->m_solute) * (Struct_Ptr->Cinit);
    fprintf (stderr, "T_pure not specified, calculating..\n");
    fprintf (stderr, "Reference Temperature Tp = %.6g\n", Struct_Ptr->T_pure);
  }
  if (ce_flag == 1) {
    Struct_Ptr->m_solute = (Struct_Ptr->Cinit - Struct_Ptr->c_eut) / (Struct_Ptr->T_liq - Struct_Ptr->T_eut);
    fprintf (stderr, "c_eut specified, OVERRIDING liquidus slope\n");
    fprintf (stderr, "Liquidus slope m = %.6g\n", Struct_Ptr->m_solute);
  } else {
    if (Struct_Ptr->m_solute != 0) {
      Struct_Ptr->c_eut = Struct_Ptr->Cinit + (Struct_Ptr->T_eut - Struct_Ptr->T_liq) / (Struct_Ptr->m_solute);
    } else {
      Struct_Ptr->c_eut = 100;
    }
    fprintf (stderr, "c_eut Not specified, calculating...\n");
    fprintf (stderr, "Eutectic Concentration = %.6g\n", Struct_Ptr->c_eut);
  }
  Struct_Ptr->Fs_eut = (Struct_Ptr->c_eut - Struct_Ptr->Cinit) / ((1 - Struct_Ptr->part_coef) * Struct_Ptr->c_eut);

  if (Struct_Ptr->Fs_eut > 1.0)
    Struct_Ptr->Fs_eut = 1.0;

  /* if phase diagram slope is not used, set inverse to zero to avoid arithmetic error */
  /* eg. for simple gas diffusion */
  if (Struct_Ptr->m_inv_solute != 0) {
    Struct_Ptr->m_inv_solute = 1 / (Struct_Ptr->m_solute);
  } else {
    Struct_Ptr->m_inv_solute = 0;
  }

  fprintf (stderr, "Fraction Solid at Eutectic Fs_eut = %.6g\n", Struct_Ptr->Fs_eut);
  fprintf (stderr, "\n\n");
}
#endif

/* End of structure Solute_props */
