
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*$Id: solprops_writer.c 1339 2008-07-23 13:58:29Z  $*/
/* AUTOGENERATED write structure routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "machine.h"
/*TO DO: MANUALLY ADD the header for the structure */
#include "solprops.h"
/*TO DO: MANUALLY ADD strings or other structures not implemented */
/*TO DO: MANUALLY REMOVE purely internal variables and flags (not to be read in) */
/* start of structure solprops */
void write_solprops_values (FILE * fp, struct solprops *Struct_Ptr)
{
  int i,i1;

  fprintf (fp, "\n# solprops STRUCTURE VALUES *****\n");
  fprintf (fp, "my_type %i \n", Struct_Ptr->my_type);
  fprintf (fp, "Cinit %g \n", Struct_Ptr->Cinit);
  fprintf (fp, "Dliq %g \n", Struct_Ptr->Dliq);
  fprintf (fp, "QaLiq %g \n", Struct_Ptr->QaLiq);
  fprintf (fp, "DoLiq %g \n", Struct_Ptr->DoLiq);

  for (i1 = 0; i1 < NPHAMAX; i1++) { 
    fprintf (fp, "Dsol[%d] %g \n",i1, Struct_Ptr->Dsol[i1]);
    fprintf (fp, "QaSol[%d] %g \n",i1, Struct_Ptr->QaSol[i1]);
    fprintf (fp, "DoSol[%d] %g \n",i1, Struct_Ptr->DoSol[i1]);
    fprintf (fp, "part_coef[%d] %g \n",i1, Struct_Ptr->part_coef[i1]);
    fprintf (fp, "m_solute[%d] %g \n",i1, Struct_Ptr->m_solute[i1]);
  }

  fprintf (fp, "mould_source_value %g \n", Struct_Ptr->mould_source_value);
  fprintf (fp, "mould_src_pert %i \n", Struct_Ptr->mould_src_pert);

  fprintf (fp, "km %g \n", Struct_Ptr->km);
  fprintf (fp, "kminv %g \n", Struct_Ptr->kminv);
  fprintf (fp, "c_eut %g \n", Struct_Ptr->c_eut);
  fprintf (fp, "T_eut %g \n", Struct_Ptr->T_eut);
  fprintf (fp, "Fs_eut %g \n", Struct_Ptr->Fs_eut);

  fprintf (fp, "m_inv_solute %g \n", Struct_Ptr->m_inv_solute);
  fprintf (fp, "surf_tens_coef %g \n", Struct_Ptr->surf_tens_coef);
}

/* End of structure Solute_props */
