
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/****************************************************************/
/* thermo_trace_calc.c:                                         */
/* Subroutine to interpolate the temperature at a point         */
/* in the CA code using values from a themrocopule trace.       */
/****************************************************************/
/****************************************************************/
/* Written by X. Xu, P.D. Lee & R.C. Atwood, Imperial College   */
/* Dec 7 1998                                                   */
/****************************************************************/
/*      MODIFIED by:                                            */
/*                                                              */
/****************************************************************/
/****** To Do List **********************************************/
/*General:                                                      */
/* 1) make it use a series of time/temp readings that arent     */
/*    necessarily equally spaced.                               */
/****************************************************************/
/*RCS Id:$Id: thermo_trace_calc.c 1341 2008-07-23 15:23:30Z  $*/
#include <stdio.h>
#include <math.h>

/* include header files requred by subroutines */
#include "machine.h"
#include "tcpl.h"

/* tt is sim_time*/
CA_FLOAT thermo_trace_calc (TC_str * tc, CA_FLOAT tt)
{
  CA_FLOAT nsteps, r, slope, Calc_T, tstart, tend;
  int indx;

#ifdef DEBUG_TCTRACE
  fprintf (stderr, "TCTRACE: Time %f \n", tt);
#endif /*DEBUG_TCTRACE */
  tstart = tc->Temp[0];
  tend = tc->Temp[(tc->Nlines) - 1];
  nsteps = tt / tc->Tstep;
  indx = (int) (FLOOR (nsteps));
  if (indx >= tc->Nlines - 1) {
    indx = tc->Nlines - 1;
    slope = (tc->Temp[indx] - tc->Temp[indx - 1]) / tc->Tstep;

  } else {
    slope = (tc->Temp[indx + 1] - tc->Temp[indx]) / tc->Tstep;
  }
  r = nsteps - (CA_FLOAT) indx;
  Calc_T = (tc->Temp[indx]) + (slope * r * ((CA_FLOAT) (tc->Tstep)));
#ifdef DEBUG_TCTRACE
  fprintf (stderr, "TCTRACE: tstep %f\n", tc->Tstep);
  fprintf (stderr, "TCTRACE: slope %f T(i) %f T(i+1) %f\n", slope, tc->Temp[indx + 1], tc->Temp[indx]);
  fprintf (stderr, "TCTRACE: nsteps %f r %f indx %i\n", nsteps, r, indx);
  fprintf (stderr, "TCTRACE: Time %f Temp %f\n", tt, Calc_T);
#endif /*DEBUG_TCTRACE */
  return (Calc_T);
}                               /* End of subroutine: thermo_trace_calc */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_thermo_trace_calc_c ()
{
  static char const rcsid[] = "$Id: thermo_trace_calc.c 1341 2008-07-23 15:23:30Z  $";

  return (rcsid);
}

/* end of rcs_id_thermo_trace_calc_c subroutine */
/*
*/
