
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*RCS Id:$Id: write_header_ctrl.c 1356 2008-08-18 13:41:15Z  $*/
/*Print all the control structure values into the header for output files */

#include <stdio.h>
#include "machine.h"
#ifdef TEST_MAIN
#include "read_ctrl_adsr.h"
#else
#include "blocks.h"
#include "read_ctrl.h"
#endif
void write_header_ctrl (FILE * ffp, BB_struct * bp)
{
  extern void write_bb_values (FILE * fp, BB_struct * bp);
  Ctrl_str *cp;

  cp = bp->ctrl;

  fprintf (ffp, "COMPILAITION FLAGS\n");
  fprintf (ffp, "%s\n", cp->cflags);
  /* FILES FOR INPUT              */
  fprintf (ffp, ",cp->fn_base,%s", cp->fn_base);
  if (cp->cap)
    fprintf (ffp, ",cp->fn_cap,%s", cp->fn_cap);
  fprintf (ffp, ",cp->fn_geo,%s", cp->fn_geo);
  fprintf (ffp, ",cp->fn_mat,%s", cp->fn_mat);
  if (cp->input)
    fprintf (ffp, ",cp->fn_inp,%s", cp->fn_inp);

  write_bb_values (ffp, bp);

#ifdef JUNK
  fprintf (ffp, "CONTROL STRUCTURE VALUES\n");

/*******************************************/
/* Control structure values                */
/*******************************************/
  fprintf (ffp, "cp->solo,%i", cp->solo);
  fprintf (ffp, ",cp->cap,%i", cp->cap);
  fprintf (ffp, ",cp->post,%i", cp->post);
  fprintf (ffp, ",cp->input,%i", cp->input);
  fprintf (ffp, ",cp->con_cast,%i", cp->con_cast);
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->particle,%i", cp->particle);
  fprintf (ffp, ",cp->diffuse,%i", cp->diffuse);
  fprintf (ffp, ",cp->pore,%i", cp->pore);
  fprintf (ffp, ",cp->diffuse_alloy,%i", cp->diffuse_alloy);
  fprintf (ffp, ",cp->diffuse_alloy_multi,%i", cp->diffuse_alloy_multi);
  fprintf (ffp, ",cp->show_eut,%i", cp->show_eut);
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->phase_diag_on,%i", cp->phase_diag_on);
  fprintf (ffp, ",cp->global_undercooling,%i", cp->global_undercooling);
  fprintf (ffp, "cp->phase_diag_on,%i", cp->phase_diag_on);
  fprintf (ffp, ",cp->diffuse_step,%i", cp->diffuse_step);
  /* sensitivity study factors */
#ifdef SENS
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->sens_DIFF,%.5g", cp->sens_DIFF);
  fprintf (ffp, ",cp->sens_SOL,%.5g", cp->sens_SOL);
  fprintf (ffp, ",cp->sens_PRESS,%.5g", cp->sens_PRESS);
  fprintf (ffp, ",cp->sens_SURFTENS,%.5g", cp->sens_SURFTENS);
  fprintf (ffp, "\n");
#endif /*SENS*/
    fprintf (ffp, "\n");
  /* Control of CA neighbourhood  */
  fprintf (ffp, "cp->umat_method,%i", cp->umat_method);
  fprintf (ffp, ",cp->scheil,%i", cp->scheil);
  fprintf (ffp, ",cp->n_neigh,%i", cp->n_neigh);
  fprintf (ffp, ",cp->seed,%d", cp->seed);

  /* FILES FOR INPUT              */
  fprintf (ffp, ",cp->fn_base,%s", cp->fn_base);
  if (cp->cap)
    fprintf (ffp, ",cp->fn_cap,%s", cp->fn_cap);
  fprintf (ffp, ",cp->fn_geo,%s", cp->fn_geo);
  fprintf (ffp, ",cp->fn_mat,%s", cp->fn_mat);
  if (cp->input)
    fprintf (ffp, ",cp->fn_inp,%s", cp->fn_inp);
  /* VARIABLES RELATED TO OUTPUT  */
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->nsbslice,%i", cp->nsbslice);
  fprintf (ffp, ",cp->nbbslice,%i", cp->nbbslice);
  fprintf (ffp, ",cp->pore_dump_sb,%i", cp->pore_dump_sb);

  fprintf (ffp, ",cp->slice_dmp_freq,%i", cp->slice_dmp_freq);
  fprintf (ffp, ",cp->tempslice,%i", cp->tempslice);
  fprintf (ffp, ",cp->floatdump,%i", cp->floatdump);
  fprintf (ffp, ",cp->excel,%i", cp->excel);

  fprintf (ffp, "\n");
  fprintf (ffp, "cp->scr_dmp_freq,%i", cp->scr_dmp_freq);
  fprintf (ffp, ",cp->nscrdumps,%i", cp->nscrdumps);
  fprintf (ffp, ",cp->rgbmode,%i", cp->rgbmode);
  fprintf (ffp, ",cp->rgbgrey,%i", cp->rgbgrey);
  fprintf (ffp, ",cp->conc_prof,%i,%i,%i", cp->conc_prof[0], cp->conc_prof[1], cp->conc_prof[2]);
  /* VARIABLES FOR CONCENTRATION OUTPUT */
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->diff_rgbmode,%i", cp->diff_rgbmode);
  fprintf (ffp, ",cp->diff_log_disp,%i", cp->diff_log_disp);
  fprintf (ffp, ",cp->diff_ratio_disp,%i", cp->diff_ratio_disp);
  fprintf (ffp, ",cp->alloy_disp_max,%.5g", cp->alloy_disp_max);
  fprintf (ffp, ",cp->gas_disp_max,%.5g", cp->gas_disp_max);
  fprintf (ffp, ",cp->diff_disp_cap,%i", cp->diff_disp_cap);
  /* VARIABLES RELATED TO TESTING */
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->fixed_Pore,%i", cp->fixed_Pore);
  fprintf (ffp, ",cp->nfPore,%i", cp->nfPore);
  fprintf (ffp, ",cp->fixed_nuc,%i", cp->fixed_nuc);
  fprintf (ffp, ",cp->nfnuc,%i", cp->nfnuc);
  fprintf (ffp, ",cp->coolrate,%i", cp->coolrate);
  fprintf (ffp, ",cp->fs_finish,%.5g", cp->fs_finish);
  fprintf (ffp, ",cp->delT,%.5g", cp->delT);
  fprintf (ffp, "\n");

/*******************************************/
/* end Control structure values            */
/*******************************************/
#endif /*JUNK*/
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_write_header_ctrl_c ()
{
  static char const rcsid[] = "$Id: write_header_ctrl.c 1356 2008-08-18 13:41:15Z  $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
/*
*/
