/* #define DEBUG_FIDAP */
/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*   email p.d.lee or r.atwood or x.xu @ic.ac.uk for details    */
/****************************************************************/

/****************************************************************/
/* T_var_read.c:                                                */
/* Subroutine to readin the temperature field at each step      */
/* in a transient state solution of the heat, mass and          */
/* momentum transfer in VAR ingots.                             */
/****************************************************************/
/* Written by X. Xu                          Imperial College   */
/* Feb.18, 2000                                                 */
/****************************************************************/
/*      MODIFIED by:                                            */
/*                                                              */
/*                                                              */
/****************************************************************/
/****** To Do List **********************************************/
/*General:                                                      */
/* 1)                                                           */
/****************************************************************/
#include <stdio.h>
#include <math.h>

/* include header files requred by subroutines */
#include "machine.h"
#include "blocks.h"
#include "fidap.h"              /* included for def. of FGrid_struct */
/****************************************************************/
/* T_var_read.c:                                                */
/* Subroutine to read in values.                                */
/****************************************************************/
/* Input Variables:                                             */
/*      		*Note: currently FIDAP geom. is trans.  */
/*      		to [mm] from [m] since [mm] used in CA  */
/*   *fg:		ptr to the FGrid_str structure that     */
/*       		holds all FIDAP geometry and T's data.  */
/*   r:		        radial dist. in macro model (m)         */
/*   z:		 	height in macro model (m)               */
/*   time:		time in the CA model             [s]    */
/*      		                                        */
/* Output Variables:    NONE                                    */
/*      		                                        */
/* Returned Value:        0                                     */
/****************************************************************/

void T_var_read (FGrid_str * fg, CA_FLOAT time)
{
  int i, j;
  CA_FLOAT T;

  fscanf (fg->fp, "" SCAN_F " " SCAN_F " ", &(fg->time_var), &(fg->h_ingot));

/* loop through reading the z locations         */
  for (i = 0; i < fg->nz; i++) {
    fscanf (fg->fp, "" SCAN_F "", &fg->z[i]);
  }
/* loop through reading the r locations         */
  for (j = 0; j < fg->nr; j++) {
    fscanf (fg->fp, "" SCAN_F "", &fg->r[j]);
  }
/* loop through reading the temperatures        */
  for (j = 0; j < fg->nr; j++) {
    for (i = 0; i < fg->nz; i++) {
      fscanf (fg->fp, "" SCAN_F "", &T);

/* Calculate the T array index from the i and j values */
      fg->Fidap_T[(fg->nr) * i + j] = T;
      if (i == 0 && j == 0) {
        fg->Fidap_T[(fg->nr) * i + j] = fg->Tmax;
      }
    }                           /* i = 0, ...... */
  }                             /* j = 0, ...... */

  /*   return(0); */
}

/* end of T_var_read(FGrid_str *fg, time). */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_T_var_read_c ()
{
  static char const rcsid[] = "$Id: T_var_read.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_fidap_interp_calc_c subroutine */

/*RCS Id:$Id: T_var_read.c 887 2006-03-01 18:21:01Z rcatwood $*/
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:38  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:52  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:33  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.3  2003/01/22 16:53:42  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:45  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 7.0.8.1  2002/08/27 14:18:16  chirazi
RCS Log:adding files for multi-component-Procast version of CA
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:36  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:10:16  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 16:04:50  rcatwood
RCS Log:Merged VAR and multiblock updated.
RCS Log:Not tested
RCS Log:
RCS Log:Revision 5.0  2000/03/01 16:00:54  rcatwood
RCS Log:Merge robert and xxu versions
RCS Log:
RCS Log:Revision 1.2  2000/02/23 16:37:12  rcatwood
RCS Log:Improved interpolation version
RCS Log:
RCS Log:Revision 1.1  2000/02/22 14:20:26  xxu
RCS Log:Initial revision
RCS Log:
RCS Log:Revision 4.3.1.1  2000/01/18 19:58:44  xxu
RCS Log:Branch for XXU fidap version
RCS Log:
RCS Log:Revision 4.3  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.2  1999/12/16 13:49:16  rcatwood
RCS Log:Combine X.Xu version to use W. Zhang program output into main trunk.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
