/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* blocks.h                                                                           */
/* Header file defining superblock structure                          */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Jul 1, 1998                                                  */
/* Jan 19 1999 RCA added fixed neighbourhood choices            */
/* June22 1999 RCA added some more diffusion stuff              */
/****************************************************************/
/****************************************************************/
/*RCS Id:$Id: blocks.h 887 2006-03-01 18:21:01Z rcatwood $*/


#ifndef BLOCKS_H
#define BLOCKS_H


#include <time.h>

#define BLOCKREV "blocks.h $Revision: 887 $"
#ifndef MACHINE_H
  #include "machine.h"
#endif /* MACHINE_H */
#ifndef PORE_H
  #include "pore.h"
#endif /* PORE_H */
#ifndef MATPROPS_H
  #include "matprops.h"
#endif /* MATPROPS_H */
#ifndef NUCPROPS_H
  #include "nucprops.h"
#endif /* NUCPROPS_H */
#ifndef READCTRL_H
  #include "read_ctrl.h"
#endif /* READCTRL_H */
#ifndef TEMPROPS_H
  #include "temprops.h"
#endif /* TEMPROPS_H */
#ifndef SOLROPS_H
  #include "solprops.h"
#endif /* SOLPROPS_H */
#ifndef MULTIPROPS_H
  #include "multi_diff_props.h"
#endif /* MULTIPROPS_H */
#ifndef FEM_H
  #include "fem.h"
#endif /* FEM_H */
#ifndef FIDAP_INTERP_H
  #include "fidap.h"
#endif /* FIDAP_INTERP_H */
#ifndef GRAIN_H
  #include "grain.h"
#endif /* GRAIN_H */
#ifndef CUBE_H
  #include "cube.h"
#endif /* CUBE_H */
#ifndef TC_INTERP_H
  #include "tcpl.h"
#endif /* TC_INTERP_H */
#ifndef NBHD_H
   #include "nbhd.h"
#endif /*NBHD_H*/
#ifndef NEARNODE_H
   #include "nearnode.h"
#endif /*NEARNODE_H*/

#ifndef PR_STRUCT_H
   #include "pr_struct.h"
#endif /*PR_STRUCT_H*/

#ifndef  SURCELL_H 
   #include "SurCell.h"
#endif /* SURCELL_H */

typedef struct blocksize_str{
    int fsize;
    int csize;
    int bbsize;
    int sbsize;
    int gsize;
    int psize;
    int PORE_size ;
    int pcnsize ;
    int pclsize ;
    int nucpropssize;
} bsize;
#ifndef TEMP_STRUCT_H
   #include "temp_struct.h"
#endif /*TEMP_STRUCT_H*/

typedef struct values {
   CA_FLOAT ** block_array;  /* the array of pointers into value array subblocks */
   FILE * fd_exel;
   char id_string[MAX_STRING_LEN]; /* id string pre-pended to output for this value*/

   CA_FLOAT disp_max; /*the max. value for displaying this value */
   CA_FLOAT part_coef; /* the partition coefficient for this value */
   CA_FLOAT CLmin;
   CA_FLOAT CLmax;
   CA_FLOAT Cmin;
   CA_FLOAT Cmax;
   CA_FLOAT Ctot;
   CA_FLOAT SSmax;
   CA_FLOAT SSmin;
   CA_FLOAT SATmax;
} Value_struct;


#include "subblock.h"
#include "bigblock.h"

#define PROCAST_INIT_BB (-3)
#define READ_BB  (-2) 
#define INIT_BB  (-1)
#define CALC_BB  (0)
#define FINISH_BB  (1)
#define WRITE_BB  (2)
#define RESTART_BB  (3)

#endif /* BLOCKS_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:38  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:52  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.3.10.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2.4.1  2004/05/24 18:36:03  rcatwood
RCS Log:Added individual surface nucleation parameters
RCS Log:
RCS Log:Revision 9.2  2003/11/18 13:22:40  rcatwood
RCS Log:Added routines to find and store the interface cells between the casting and the mould.
RCS Log:Added the surface cell storage structure to the subblock.
RCS Log:Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:33  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.3.4.4  2003/08/14 14:17:56  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.3.4.3  2003/01/22 16:53:42  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.3.4.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.3.2.1  2002/11/06 17:27:45  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.2  2002/10/25 12:17:00  rcatwood
RCS Log:Merged cygwin portable version for Windows machines
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:00  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.2  2002/10/17 16:52:36  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.1.12.8  2002/10/04 16:21:27  rcatwood
RCS Log:adjusted the reporting of fraction solid, to allow for multi block
RCS Log:
RCS Log:Revision 7.1.12.7  2002/09/19 18:34:57  rcatwood
RCS Log:First working restart version using bin-block file
RCS Log:
RCS Log:Revision 7.1.12.6  2002/09/18 12:36:15  rcatwood
RCS Log:Split step output function into a subroutine (called from ca_solid)
RCS Log:Removed some lint errors.
RCS Log:
RCS Log:Revision 7.1.12.5  2002/09/16 18:11:54  rcatwood
RCS Log:Added read/write pores to read-blocks routines
RCS Log:
RCS Log:Revision 7.1.12.4  2002/09/12 10:48:08  rcatwood
RCS Log:Changed pore routine to avoid getxyz routine
RCS Log:
RCS Log:Revision 7.1.12.3  2002/08/30 19:18:24  rcatwood
RCS Log:split bigblock and subblock allocation into seperate subroutines
RCS Log:from bigblock.c and open_sb.c: added alloc_bb.c and alloc_sb.c
RCS Log:
RCS Log:Revision 7.1.12.2  2002/08/27 11:04:33  rcatwood
RCS Log:Collected decentered arrays togehter + commented
RCS Log:
RCS Log:Revision 7.1.12.1  2002/08/22 15:13:43  ww1
RCS Log:Merge of Wei Wang's decentered octahedron/square method
RCS Log:Revision 7.1.4.4  2002/07/09 14:30:27  rcatwood
RCS Log:Changed subblock open flag to 3 values: new, open,and closed. This is to aviod re-opening blocks that are already processed.
RCS Log:COmpiles and runs without seg fault.
RCS Log:
RCS Log:Revision 7.1.4.3  2002/05/29 14:24:50  rcatwood
RCS Log:Working up to subblock header & array data
RCS Log:
RCS Log:Revision 7.1.4.2  2002/05/29 10:44:06  rcatwood
RCS Log:rearranged the structues to put the pointers at the end
RCS Log:hopefully to simplify resetting or expanding the block structure
RCS Log:
RCS Log:Revision 7.1.4.1  2002/05/27 18:40:17  rcatwood
RCS Log:Added revision string macro (to help check multiblock reading)
RCS Log:
RCS Log:Revision 7.1  2001/07/20 13:30:53  rcatwood
RCS Log:added realtime screen output, improved grain nuc histogram
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.1  2000/10/16 10:37:22  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:36  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.4  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.3  2000/06/12 16:23:30  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.2  2000/06/06 18:43:04  rcatwood
RCS Log:Changed r start and growth of pores -- pore radius equilibrium
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.2  2000/05/04 18:36:45  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:Revision 1.3  2000/02/23 18:43:33  xxu
RCS Log:added prototyeps
RCS Log:
RCS Log:Revision 1.2  2000/02/23 16:20:46  rcatwood
RCS Log:Merge robert and xxu versions
RCS Log:
RCS Log:Revision 1.1.1.4  2000/02/22 18:24:16  rcatwood
RCS Log:Removed function pointer idea.
RCS Log:Needs recursive structure definition, cant figure out.
RCS Log:
RCS Log:Revision 1.1.1.2  2000/02/22 14:53:43  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 4.5  2000/02/16 10:51:47  rcatwood
RCS Log:Fixed grain structure
RCS Log:
RCS Log:Revision 4.4  2000/02/15 15:29:11  rcatwood
RCS Log:Version after McWasp submitted
RCS Log:
RCS Log:Revision 4.3  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.2  1999/12/21 10:26:15  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
