#include <stdio.h>
#include <math.h>
#include "common.h"
#include "blocks.h"

#define STD_TMP 273.16
#define STD_ATM 1.0e-06
/*$Id:*/

/* procast variables ??? */
extern int Imax, Jmax, Kmax, ncell;
extern float deltaX, deltaY, deltaZ;
extern int *cell_elem;
extern double Xmin, Ymin, Zmin;
/*end procast variables ??? */

/* procast functions ??? */
extern double cool_mod ();
extern double conc_mod ();
extern double quad_mod ();
extern void src_assem ();
extern void src_lhs ();
extern double temp_mod ();
/*end procast functions ??? */

/***************************************************************************/
/******this routine  feedbacks the values of pressure and             ******/
/******fraction solid calculated at microscale into the Procast*************/
/***************************************************************************/

extern float min_temp_calc_procast (BB_struct * bp);
int ca_feedback (BB_struct * bp, int sbnum)
{

  int current_element;
  int *numcell;
  int *elemflag;
  int *nodepor;
  int *numcellpor;
  float *nodefs;
  PORE_str *c_p;
  p_c_node *p_node;

  int offset, node, mat, curve, l;
  register int i, j, k, in, ic;
  float xc, yc, zc;
  int current_npe, node_number;
  float new_fs, old_fs, dfs;
  double q_value[10];
  float value, loc_rho, latent_heat;

#ifdef VERBOSE_PROCAST
  FILE *fp_1;
#endif

  numcell = (int *) calloc (nnod, sizeof (int));        /* number of cells the node */
  nodepor = (int *) calloc (nnod, sizeof (int));        /* number pore cells for the node */
  elemflag = (int *) calloc (nel, sizeof (int));        /* flag -- has the element been assebled? */
  nodefs = (float *) calloc (nnod, sizeof (int));       /* averaged fraction solid for the node */

  if (numcell == NULL || nodefs == NULL) {
    fprintf (stderr, "ERROR: ca_feedback: calloc failed! \n");
    exit (938);
  }
#ifdef VERBOSE_PROCAST
  fp_1 = fopen ("ca_feedback.out", "w+");
#endif

  /* find the average fs for the cells nearest each node */
  /* accumulate the sum */
  for (i = 0; i < bp->total_cell_number; i++) {
    if (bp->cell_node_array[i] >= 0) {
      node = bp->cell_node_array[i];
      nodefs[node] += (float) (bp->sb[sbnum]->c_fs[i]);
      numcell[node]++;

    }
  }

  if (bp->ctrl->pore) {
    c_p = bp->sb[sbnum]->porelist;
    for (i = 0; i < bp->sb[sbnum]->Npores; i++, c_p++) {
      switch (c_p->State) {
      case PORE_FROZEN:
      case PORE_MULTI:
      case PORE_TUBE:
      case PORE_SPHERE:
        for (p_node = c_p->boundary->first; p_node != NULL; p_node = p_node->next) {
          node = bp->cell_node_array[p_node->cellnum];
          nodepor[node]++;
        }
        break;
      case PORE_NONE:
      case PORE_OFF:
      case PORE_LATENT:
        break;
      default:
        break;
      }
    }
  }

  /* For each node, now ratio by the number of contributing cells */
  for (node = 0; node < nnod; node++) {
    if (numcell[node] > 0) {
#ifdef VERBOSE_PROCAST
      fprintf (fp_1, "(before) i-node-fs1-t1:\t %d \t %d \t %f \t %f \n", i, node, fs1[node], t1[node]);
#endif
      nodefs[node] /= (float) (numcell[node]);
      old_fs = fs0[node];
      new_fs = fs1[node];
      /* fs1 is the new fraction solid (global Procast array) */
#ifdef NOFS_PROCAST
      fs1[node] = 1;
#else
      fs1[node] = nodefs[node];
#ifdef VERBOSE_PROCAST
      if (nodefs[node] > 0) {
        static unsigned int counter = 0;

        if (counter < 50) {
          fprintf (stderr, "Feeding back fraction solid %.5g\n", nodefs[node]);
          counter++;
        }
      }
#endif /*VERBOSE_PROCAST */
#endif /*NOFS_PROCAST */
      if (bp->ctrl->pore) {
        vf_s1[node] = (float) (nodepor[node]) / (float) (numcell[node]);
      }
      /*fs1[node]=100.0;
         vf_s1[node]=0.1; */
#ifdef VERBOSE_PROCAST
      fprintf (fp_1, "         i-node-fs1-t1:\t %d \t %d \t %f \t %f \n", i, node, fs1[node], t1[node]);
#endif
    }
  }
  /* end of fraction solid feedback */

  /* porosity volume feedback */

#ifdef Q_FEEDBACK_ROUTINE
  /* for each element, load the latent heat released into q_value. */
  /* src_assem assembles this information into the global rhs vector */
  for (i = 0; i < ncell; i++) {
    if (bp->cell_element_array[i] >= 0 && elemflag[bp->cell_element_array[i]] == 0) {
      current_element = bp->cell_element_array[i];
      elemflag[current_element] = 1;

      mat = mat_num[mat_id[current_element]];
      latent_heat = lat_heat[mat];

      for (j = 0; j < 10; j++) {
        q_value[j] = (double) 0.0;
      }

      for (j = 0; j < npe[el_type[current_element]]; j++) {
        node = ncon[current_element][j];

        /* evaluate the variation in fraction solid at each node */
        old_fs = fs0[node];
        new_fs = fs1[node];
        if (new_fs > 1.0) {
          dfs = 1.0 - old_fs;
        } else {
          dfs = new_fs - old_fs;
        }
         /**********************************/

        curve = i_dens[mat];
        value = 1.0;

        /* Find the density as a function of temperature */
        /* using the information provided to Procast */
        if (curve > 0) {
          l = curve - 1;
          value = temp_mod (t1[node], l);
        } else if (curve < 0) {
          l = -(curve + 1);
          value = quad_mod (t1[node], l);
        }

        loc_rho = value * density[mat];

        q_value[j] = (double) (loc_rho * latent_heat * dfs / dt);

        /*q_value[j] = 10000000000000.00; */
      }
      src_assem (current_element, q_value);
    }                           /* end of main if loop */
  }                             /* end of cell loop */
#ifdef VERBOSE_PROCAST
  for (node = 0; node < nnod; node++) {
    if (numcell[node] > 0) {
      fprintf (fp_1, "(after)  i-node-fs1-t1:\t %d \t %d \t %f \t %f \n", i, node, fs1[node], t1[node]);
    }
  }
#endif /* VERBOSE_PROCAST */
#endif /*Q_FEEDBACK_ROUTINE */

#ifdef VERBOSE_PROCAST
  fclose (fp_1);
#endif

  free (numcell);
  free (elemflag);
  free (nodefs);
  free (nodepor);
  return (1);
}

/***************************************************************************/
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *ca_feedback_c ()
{
  static char const rcsid[] = "$Id: ca_feedback.c 899 2006-03-15 17:45:04Z rcatwood $";

  return (rcsid);
}
