#include <stdio.h>
#include <math.h>
#include "machine.h"

/********************************************************/
/********************************************************/
/* init_stat_val                                       	*/
/*    initialise an array for holding stat values.      */
/********************************************************/
/********************************************************/
/* stat[] should be an array of 4 (0-3) CA_FLOAT */
/* It will hold the sum, min,max, and sumsq */
/* after calc_stat_val is applied, it will hold */
/* the mean, min, max, and stdev of the values input */
void init_stat_val (CA_FLOAT stat[])
{
  stat[0] = stat[2] = stat[3] = 0.0;
  stat[1] = LARGE;
}

/********************************************************/
/********************************************************/
/* add_stat_val                                       	*/
/*    add a single values to the stats array.           */
/********************************************************/
/********************************************************/
void add_stat_val (CA_FLOAT stat[], CA_FLOAT val)
{
  stat[0] += val;
  stat[1] = MIN (stat[1], val);
  stat[2] = MAX (stat[2], val);
  stat[3] += (val * val);
}

/********************************************************/
/********************************************************/
/* calc_stat_val                                       	*/
/*    Calculate the stat values after all inst's. added.*/
/********************************************************/
/********************************************************/
void calc_stat_val (CA_FLOAT stat[], CA_FLOAT dn)
{
  double dval;

  if (dn > 1.01) {
    stat[0] /= dn;
    dval = stat[0] * stat[0];
    if (dn * dval > stat[3]) {
      fprintf (stderr, "stddev of neg: ss=%g; dn*avg^2=%g;dn=%g;avg=%g\n", stat[3], dn * dval, dn, stat[0]);
      stat[3] = 0.0;
    } else {
      dval = (stat[3] - dn * dval) / (dn - 1.0);
      stat[3] = sqrt (dval);
    }
  } else                        /* only one sample so no deviation */
    stat[3] = 0.0;

  if (stat[1] >= (0.5 * LARGE))
    stat[1] = 0;
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_castats_c ()
{
  static char const rcsid[] = "$Id: castats.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
