#include <stdio.h>
#include <stdlib.h>
#include "safeopen.h"
#include "machine.h"
#include "blocks.h"
#include "read_sb.h"
extern void free_sb_arrays (BB_struct * bp, int sbnum);
extern int free_pore (PORE_str * porelist, int npores);

/* print an ascii listing of all the grains and free them up*/
/**  \todo  should seperate the write and free bits -- multiblock */
/* allowing optional writing/bin dump/maybe none */
void grain_write (BB_struct * bp, int sbnum)
{
  int i = 0, j = 0, *gp, *wf;
  Ind_grain *grainp;
  FILE *fp;
  char fname[MAX_STRING_LEN];
  SB_struct *sp;

  /* flag for already written grains - multiblock */
  /* wf: written-flag */
  wf = (int *) calloc (bp->nprops.ngr, sizeof (int));

  sp = bp->sb[sbnum];

  sprintf (fname, "GR_%s_sb%i.csv", bp->ctrl->fn_base, sbnum);
  fp = fopen (fname, "w");

  fprintf (fp, "num,state,sbnum,cell,ncells,ngrow,blocks,Tnuc,Tund,Conc,xmax,ymax,zmax,xnuc,ynuc,znuc,xmin,ymin,zmin,angle\n");
  /* loop through and write grain info */
  for (gp = sp->gr; gp < (sp->gr + bp->ncsb); gp++) {
    if (bp->gr[*gp] == NULL)
      continue;                 /*already destroyed */
    if (*(wf + *gp) != 0)
      continue;                 /* already written */
    grainp = bp->gr[*gp];

    /* write out the info */
    /**  \todo  protect with an option to allow freeing without writing -- multiblock */
    /* neede for LARGE models , stats only */
    fprintf (fp, "%i,%i,%i,%i,%i,%i,%i,",
             grainp->num, grainp->state, grainp->sbnum, grainp->cell, grainp->ncells, grainp->ngrow, grainp->blocks);
    fprintf (fp, "%.5g,%.5g,%.5g,", grainp->TNuc, grainp->TunderNuc, grainp->CellConcNuc);
    for (i = 0; i < 3; i++)
      fprintf (fp, "%i,", grainp->max[i]);
    for (i = 0; i < 3; i++)
      fprintf (fp, "%i,", grainp->nuccell[i]);
    for (i = 0; i < 3; i++)
      fprintf (fp, "%i,", grainp->min[i]);
    fprintf (fp, "%.5g", grainp->dir_angle);
    fprintf (fp, "\n");

    /*DBM flag for dbMalloc usage */
    /* try to trap grains which have not been freed */
#ifdef DBM
    fprintf (stderr, "trap,*gp,num,mem:,%i,%i,%i,%x,", j++, *gp, grainp->num, grainp);
#endif
    if (grainp->blocks == 1) {
      free (grainp);
      bp->gr[*gp] = NULL;
#ifdef DBM
      fprintf (stderr, "freed.\n");
#endif
    } else {
      /* set flag to not duplicate information for multiblock grains */
      *(wf + *gp) = 1;
#ifdef DBM
      fprintf (stderr, "notfreed.\n");
#endif
    }
  }                             /* end of loop through grain array */
  fclose (fp);
  free (wf);
}                               /* end of grain_write */

/*******************************/
/**** close_sb ****************/
/* finish off a sb that has ***/
/* frozen completely **********/
/* and recover the memory    */
/*******************************/

int close_sb (BB_struct * bp, int sbnum)
{
  int errors = 0;
  SB_struct *sp;

  sp = bp->sb[sbnum];
  if (sp->open != SB_OPEN) {    /* check if it is open */
    fprintf (stderr, "ERROR: close_sb: sb %i is not open.\n", sbnum);
    errors++;
    return (errors);
  }

  fprintf (stderr, "close_sb: closing sb %i\n", sbnum);
  sp->open = SB_CLOSED;
  bp->sb_mask[sbnum] = FALSE;

/*
            Regular block/slice output shoudl be called
            just before close_sb so we don't need to do it here.
*/

/****************** Write out the grain info and free************************/
  grain_write (bp, sbnum);

/****************** Write out the pore info and free************************/
  /* TODO need to do pore_write on close_sb  -- porosity  multiblock*/
  /* need to save out the porosity info for a block that is completely finished*/
  /* so that memory can be reclaimed */
  /* pore_write(bp,sbnum); */

  if (bp->ctrl->pore) {
    free_pore (sp->porelist, sp->Npores);
    free (sp->porelist);
  }

  /*free the arrays in sb */
  free_sb_arrays (bp, sbnum);

  return (errors);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_close_sb_c ()
{
  static char const rcsid[] = "$Id: close_sb.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
