/*---------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008     
			allocate memory and free memory
*/
/*---------------------------------------------------------------------*/

#include "ff_mpflow.h"
#include "ff_memory.h"

int ff_alloc_bb(BB_struct *bp)
{
   int IMAX, JMAX, KMAX;

   IMAX = bp->tnc[0];
   JMAX = bp->tnc[1];
   KMAX = bp->tnc[2];

   bp->ca_cell_u = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_v = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_w = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_p = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  
   bp->ca_cell_t = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_h = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   
//   bp->ca_cell_fl = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_ce = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_ftry = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_dfs = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

   bp->cell_f = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->cell_g = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->cell_h = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ppe_rhs = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   
   bp->conv_x_old = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->conv_y_old = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->conv_z_old = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
//   bp->ca_cell_uold = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
//   bp->ca_cell_vold = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
//   bp->ca_cell_wold = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   bp->ca_cell_delp = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	
   bp->cflag = intmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

   return 0;

}



int ff_free_bb(BB_struct *bp)
{
   int IMAX, JMAX, KMAX;

   IMAX = bp->tnc[0];
   JMAX = bp->tnc[1];
   KMAX = bp->tnc[2];
       
   freerealmem(bp->ca_cell_u, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_v, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_w, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_p, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_t, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_h, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   
//   freerealmem(bp->ca_cell_fl, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_ce, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_ftry, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_dfs, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

   freerealmem(bp->cell_f, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->cell_g, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->cell_h, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ppe_rhs, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

   freerealmem(bp->conv_x_old, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->conv_y_old, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->conv_z_old, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freeintmem(bp->cflag, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   
//   freerealmem(bp->ca_cell_uold, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
//   freerealmem(bp->ca_cell_vold, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
//   freerealmem(bp->ca_cell_wold, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
   freerealmem(bp->ca_cell_delp, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

   return 0;

}

