/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/*RCS Id:$Id: init_sb_neigh.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include "machine.h"
#include "blocks.h"
#define LP_COMMAND  fprintf(stderr,"ISBN:ii before %i"\
                                        "\n nouts: %i\n",ii,nouts);\
                    bp->sb[ii]->nouts=nouts;\
                    bp->sb[ii]->code=code;\
                    if(ii>=bp->ntsb) {fprintf(stderr,"INSB:ERROR too many sb");\
                    exit(0);}\
                    ii++;\
                    fprintf(stderr,"ISBN:Ecount %i / %i\n",ecount++,bp->ntsb);

/**************************************************/
/*                                                */
/* init_sb_neigh -- set up the pointers to the    */
/* neighbours of each subblock.                   */
/*                                                */
/**************************************************/
/* bp = pointer to bigblock                       */
/* flag = scheme for wrapping, padding, fixed     */
/*        boundary etc.                           */
/**************************************************/

int init_sb_neigh (BB_struct * bp, int flag)
{
  int ii, i, j, k;
  int ecount = 0;
  int nouts, code;
  int bbins[3];                 /* local version of inside dim. of bigblock */
  FILE *out;
  int xy_only = FALSE;

  for (i = 0; i < 3; i++)
    bbins[i] = bp->cubeptr.bbins[i];

  if (bbins[2] == 0)
    xy_only = TRUE;
  else if (bbins[0] == 0 || bbins[1] == 0) {
    fprintf (stderr, "ERROR:init_sb_neigh: Sorry, only 3-d or X-Y 2-dimensional multiblocks supported.\n");
    fprintf (stderr, "*******************************************************************************");
    fprintf (stderr, "* Please rewrite the array-copying subsystem if you require other geometries. *\n");
    fprintf (stderr, "*******************************************************************************");
    exit (0);
  }
#ifdef VERBOSE
  out = fopen ("code.table", "w");
#endif
  ii = 0;
  k = 0;
  j = 0;
  i = 0;

/**************************************************/
/*  If one singel subblock, easy out.             */
/**************************************************/
  if (bp->ntsb == 1) {

    bp->sb[ii]->nouts = 6;
    bp->sb[ii]->code = 0;
    return (0);
  } else if (xy_only) {

/**************************************************/
/*                                                */
/*                                                */
/*                                                */
/*   flat 2d multiblocks                          */
/*   XY plane only !                              */
/*                                                */
/*                                                */
/**************************************************/
/**************************************************/
/*  Front  Left corner (000)                */
/**************************************************/
    nouts = XY_CORN;
    code = 0;
    LP_COMMAND
/**************************************************/
/*  Front Edge (i00)                        */
/**************************************************/
      nouts = XY_EDGE;
    code = 0;
    for (i = 1; i < bbins[0]; i++) {
    LP_COMMAND}

/**************************************************/
/*  Front  Right corner (n00)                */
/**************************************************/
    nouts = XY_CORN;
    code = 1;
    LP_COMMAND
/**************************************************/
/* The bottom surface                             */
/**************************************************/
      for (j = 1; j < bbins[1]; j++) {
   /**************************************************/
      /* a   left edge                            */
   /**************************************************/
      nouts = XY_EDGE;
      code = 4;
      LP_COMMAND
   /**************************************************/
        /* a row of face units                     */
   /**************************************************/
        nouts = XY_INS;
      code = 0;
      for (i = 1; i < bbins[0]; i++) {
      LP_COMMAND}
   /**************************************************/
      /* a right edge                                   */
   /**************************************************/
      nouts = XY_EDGE;
      code = 5;
    LP_COMMAND}
/**************************************************/
/*  Back  Left corner                       */
/**************************************************/
    nouts = XY_CORN;
    code = 2;
    LP_COMMAND
/**************************************************/
/* Back Edge                               */
/**************************************************/
      nouts = XY_EDGE;
    code = 2;
    for (i = 1; i < bbins[0]; i++) {
    LP_COMMAND}
/**************************************************/
/*  Back Right corner                       */
/**************************************************/
    nouts = XY_CORN;
    code = 3;
    LP_COMMAND return (0);
  } else {
/**************************************************/
/*                                                */
/*                                                */
/*                                                */
/*   three d multiblocks                          */
/*                                                */
/*                                                */
/*                                                */
/**************************************************/
/**************************************************/
/* Bottom Front  Left corner (000)                */
/**************************************************/
    nouts = CM_CORN;
    code = 0;
    LP_COMMAND
/**************************************************/
/* Bottom Front Edge (00i)                        */
/**************************************************/
      nouts = CM_EDGE;
    code = 0;
    for (i = 1; i < bbins[0]; i++) {
    LP_COMMAND}
/**************************************************/
/* Bottom Front Right corner (00n)                 */
/**************************************************/
    nouts = CM_CORN;
    code = 1;
    LP_COMMAND
/**************************************************/
/* The bottom surface                             */
/**************************************************/
      for (j = 1; j < bbins[1]; j++) {
   /**************************************************/
      /* a  bottom left edge                            */
   /**************************************************/
      nouts = CM_EDGE;
      code = 4;
      LP_COMMAND
   /**************************************************/
        /* a row of bottom face units                     */
   /**************************************************/
        nouts = CM_FACE;
      code = 4;
      for (i = 1; i < bbins[0]; i++) {
      LP_COMMAND}
   /**************************************************/
      /* a right edge                                   */
   /**************************************************/
      nouts = CM_EDGE;
      code = 5;
    LP_COMMAND}
/**************************************************/
/* Bottom Back  Left corner                       */
/**************************************************/
    nouts = CM_CORN;
    code = 2;
    LP_COMMAND
/**************************************************/
/* Bottom Back Edge                               */
/**************************************************/
      nouts = CM_EDGE;
    code = 2;
    for (i = 1; i < bbins[0]; i++) {
    LP_COMMAND}
/**************************************************/
/* Bottom Back Right corner                       */
/**************************************************/
    nouts = CM_CORN;
    code = 3;
    LP_COMMAND
/**************************************************/
/* The central layers                             */
/**************************************************/
      for (k = 1; k < bbins[2]; k++) {
   /**************************************************/
      /*  The front left edge                           */
   /**************************************************/
      nouts = CM_EDGE;
      code = 8;
      LP_COMMAND
   /**************************************************/
        /*  the row in the front surface                  */
   /**************************************************/
        nouts = CM_FACE;
      code = 2;
      for (i = 1; i < bbins[0]; i++) {
      LP_COMMAND}
   /**************************************************/
      /*  The front right edge                          */
   /**************************************************/
      nouts = CM_EDGE;
      code = 8;
      LP_COMMAND
   /**************************************************/
        /*  An Internal Row                               */
   /**************************************************/
        for (j = 1; j < bbins[1]; j++) {
      /**************************************************/
        /*  The Left face                                 */
      /**************************************************/
        nouts = CM_FACE;
        code = 0;
        LP_COMMAND
         /**************************************************/
          /* The Internal blocks                            */
         /**************************************************/
          nouts = CM_INS;
        code = 0;
        for (i = 1; i < bbins[0]; i++) {
        LP_COMMAND}

      /**************************************************/
        /*  The Right face                                */
      /**************************************************/
        nouts = CM_FACE;
        code = 1;
      LP_COMMAND}
   /**************************************************/
      /*  End Internal Row                              */
   /**************************************************/
   /**************************************************/
      /*  The back  left edge                           */
   /**************************************************/
      nouts = CM_EDGE;
      code = 10;
      LP_COMMAND
   /**************************************************/
        /*  the row in the back  surface                  */
   /**************************************************/
        nouts = CM_FACE;
      code = 3;
      for (i = 1; i < bbins[0]; i++) {
      LP_COMMAND}
   /**************************************************/
      /*  The back  right edge                          */
   /**************************************************/
      nouts = CM_EDGE;
      code = 11;
    LP_COMMAND}
/**************************************************/
/*  End Central Layer                             */
/**************************************************/
/**************************************************/
/* Top Front  Left corner (000)                */
/**************************************************/
    nouts = CM_CORN;
    code = 4;
    LP_COMMAND
/**************************************************/
/* Top Front Edge (00i)                        */
/**************************************************/
      nouts = CM_EDGE;
    code = 1;
    for (i = 1; i < bbins[0]; i++) {
    LP_COMMAND}
/**************************************************/
/* Top Front Right corner (00n)                 */
/**************************************************/
    nouts = CM_CORN;
    code = 5;
    LP_COMMAND
/**************************************************/
/* The Top surface                             */
/**************************************************/
      for (j = 1; j < bbins[1]; j++) {
   /**************************************************/
      /* a  Top left edge                            */
   /**************************************************/
      nouts = CM_EDGE;
      code = 6;
      LP_COMMAND
   /**************************************************/
        /* a row of Top face units                     */
   /**************************************************/
        nouts = CM_FACE;
      code = 5;
      for (i = 1; i < bbins[0]; i++) {
      LP_COMMAND}
   /**************************************************/
      /* a right edge                                   */
   /**************************************************/
      nouts = CM_EDGE;
      code = 7;
    LP_COMMAND}
/**************************************************/
/* Top Back  Left corner                       */
/**************************************************/
    nouts = CM_CORN;
    code = 6;
    LP_COMMAND
/**************************************************/
/* Top Back Edge                               */
/**************************************************/
      nouts = CM_EDGE;
    code = 3;
    for (i = 1; i < bbins[0]; i++) {
    LP_COMMAND}
/**************************************************/
/* Top Back Right corner                       */
/**************************************************/
    nouts = CM_CORN;
    code = 7;
    LP_COMMAND
/**************************************************/
/* All done                                       */
/**************************************************/
  }
#ifdef VERBOSE
  fclose (out);
#endif
  return (0);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_init_sb_neigh_c ()
{
  static char const rcsid[] = "$Id: init_sb_neigh.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_init_sb_neigh_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.3  2003/03/21 18:16:41  rcatwood
RCS Log:added flat (xy-plane) mulitblock geometry
RCS Log:Tried to improve Makefile for ca_read
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/14 16:22:25  rcatwood
RCS Log:Removed many lint warnings from sb_decentered_step
RCS Log:Added signal function to ca_procast
RCS Log:Removed some unused files
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:01  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.1  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.0.14.1  2002/10/10 12:06:06  rcatwood
RCS Log:Merge pore and decentered square -- but restart needs work
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:35  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
