/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* matprops.h                                                   */
/* Header file defining material property related structures    */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Wed Jul  1 18:38:31 bst 1998                                 */
/****************************************************************/
/*RCS Id:$Id: matprops.h 1450 2009-02-11 12:21:37Z  $*/

#ifndef MATPROPS_H
#define MATPROPS_H

#include "solprops.h"

/****************************************************************/
/* The material properties structure, which holds     */
/* values which are constant for the whole big block  */
/****************************************************************/

#define MATPROPREV "matprop.h $Revision: 1450 $"
typedef struct matprop {
                        /*************MATERIAL PROPS*************/
	
        CA_FLOAT tp;               /* temperature of pure component in binary system */
        CA_FLOAT Tliq;             /* liquidus temperature [K]             */
	CA_FLOAT Tsol;             /* solidus temperature [K]              */
        CA_FLOAT Tstart_Offset;    /* the offset value added to the liquidus temperature */
	CA_FLOAT Tstart;           /* Tliq plus offset used for opening sb's*/
	CA_FLOAT latentH;          /* latent heat [J/mm^3]                 */
	CA_FLOAT rho;              /* density [g/mm^3]                     */
	CA_FLOAT cp;               /* Cp [J/g/K]                           */
	CA_FLOAT rhocp;            /* rho * Cp [J/mm^3/K]                  */
	CA_FLOAT CA_Q;             /* heat flux */
	CA_FLOAT QSV;              /*  Q*surf area/vol          */
	CA_FLOAT surf_tens;        /* Surface tension [mK] use for Z-recry */
        CA_FLOAT gibbs_thomson;    /* coefficient de Gibbs-Thomson for the calculation of the curvature undercooling */
	CA_FLOAT gg_const;		/* grain growht const M/s/K            */
	CA_FLOAT gg_cub;        /*coefficient of t^3 in grain growth eqn*/
        CA_FLOAT dt_melt;       /*amount of superheating for remelting*/

        int stoechio; /*indicate if the secondaryr phase is stoechiometrique or not*/

	/* parameters for fluid flow and heat transfer*/  //lyuan
	CA_FLOAT thermcond;
	CA_FLOAT beta_T;
	CA_FLOAT beta_c;
	CA_FLOAT ref_T;
	CA_FLOAT ref_c;
	CA_FLOAT viscosity;
	CA_FLOAT gravity_x;
	CA_FLOAT gravity_y;
	CA_FLOAT gravity_z;
	CA_FLOAT CCconst;
	/* curvature  //lyuan */
	CA_FLOAT therm_anis;
	
	

	/* Moved the properties to individual structure for each component */
	/* see solprops.h */
	/* included as nested structure (not pointer) to simplify the writing */
	/* and reading of blk restart files */
	Solute_props gasprops;
	int ele_1;  /* number of solutes equals number of total components minus 1 */  
	            /* not counting gas */
	Solute_props alloyprops[NSOLMAX];
        
        CA_FLOAT Tliq_poly[NPHAMAX]; /* One value per phase */
        CA_FLOAT tp_poly[NPHAMAX];   /* Effective pure melting point One value per phase */

	CA_FLOAT das_factor; /* geometric factor for das ?? */
	CA_FLOAT das;  /* calculated DAS for limiting pressure calc. */
                	/* constants to define simplified binary phase diagram */
} Mat_str;

#endif /* MATPROPS_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.4.2.8  2006/02/20 14:51:23  rcatwood
RCS Log:Correced evil log message
RCS Log:
RCS Log:Revision 10.4.2.7  2006/02/20 12:00:13  lthuinet
RCS Log: A lot of modifications : add an option to treat correctly diffusion in the case the secondary eutectic phase is stoechiometric AND add a pointer to distinguish the nature of the cell and the nature of the grain
RCS Log:
RCS Log:Revision 10.4.2.6  2006/02/01 14:16:25  lthuinet
RCS Log:#update change of the calculation of supersaturation for gas in multicomponent
RCS Log:
RCS Log:Revision 10.4.2.5  2006/01/20 16:28:21  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.4.2.4  2006/01/18 18:35:11  rcatwood
RCS Log:started makeing example input files for the new version
RCS Log:
RCS Log:Revision 10.4.2.3  2006/01/18 12:01:17  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.4.2.2  2006/01/11 12:12:19  rcatwood
RCS Log:Altered to use the new solute properties structure arrays
RCS Log:
RCS Log:Revision 10.4.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.4  2005/12/06 13:09:54  rcatwood
RCS Log:Changed todo lists to Doxygen syntax
RCS Log:
RCS Log:Revision 10.3  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1.2.1  2005/11/07 17:47:56  rcatwood
RCS Log:Branch uisng Xiao Li Yang final version
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 9.1.4.2.6.1  2005/02/16 12:41:46  xly
RCS Log:*** empty log message ***
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1.4.2  2004/03/09 11:30:53  rcatwood
RCS Log:Changed to read materials properties from separate files for alloy and gas
RCS Log:
RCS Log:Revision 9.1.4.1  2004/03/04 11:29:24  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:37  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.4  2003/05/06 15:48:07  rcatwood
RCS Log:Altered linear binary phase diagram usage to consistently use the values input from the control files rather than the header files.
RCS Log:
RCS Log:Revision 8.1.8.3  2003/01/22 16:53:44  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:47  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 7.0.8.2  2002/11/04 11:22:05  rcatwood
RCS Log:Check-in after Ali has gone
RCS Log:
Trimmed the in-file log. Use cvs log facility to see the entire log.
*/
