/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publicatinbhd->on of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material cnbhd->ontains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplicatinbhd->on or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/*  nbhd_def.c:                                                 */
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* jan 19, 1998                                                  */
/****************************************************************/
/*      MODIFIED by:                                            */
/****************************************************************/
/****** To Do List **********************************************/
/*General:  27 member neibhorhood needs doing                   */
/****************************************************************/
/*RCS Id:$Id: nbhd_def.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include "machine.h"
#include "blocks.h"
/******************************************************/
/*                                                    */
/* This routine initializes all currently implemented */
/* CA neighbourhoods and stores them in the nbhd      */
/* structure within the BB structure. As other        */
/* neighbourhoods are implemented they may be added   */
/* to this file, ensuring that the N_NEIGH and n_neigh*/
/* parameters in other files are compatible.          */
/*                                                    */
/* This file gets passed the bigblock structure       */
/* pointer and modifies the members of the nbhd      */
/* substructure.                                      */
/*                                                    */
/*                                                    */
/******************************************************/
void nbhd_def (BB_struct * bp)
{
  Nbhd_str *nbhd;               /* local pointer to nbhd structure in bb */
  int nx, ny, nz;               /* size in x,y,z direction of subblock   */
  int i, j, k;
  int yup, zup, *cnpt;          /*precalc shift factors */

  /* set up local pointers */
  nbhd = &(bp->nbhd);
  nx = bp->nc[0];
  ny = bp->nc[1];
  nz = bp->nc[2];

/************************************************/
/* Set up quad neighbourhoods....                */
/************************************************/
  /* set neighbourhood index array into old (padded) array */
  nbhd->onq[0] = -1;
  nbhd->onq[1] = 1;
  nbhd->onq[2] = -(nx + 2);
  nbhd->onq[3] = (nx + 2);
  nbhd->onq[4] = -(nx + 2) * (ny + 2);
  nbhd->onq[5] = (nx + 2) * (ny + 2);
  /* set neighbourhood index array into new (non-padded) array */
  nbhd->nnq[0] = -1;
  nbhd->nnq[1] = 1;
  nbhd->nnq[2] = -nx;
  nbhd->nnq[3] = nx;
  nbhd->nnq[4] = -nx * ny;
  nbhd->nnq[5] = nx * ny;
/************************************************/
/* Set up hex neighbourhoods....                */
/************************************************/
  /* set neighbourhood index array into old (padded) array */
  nbhd->onhl[0] = -1;
  nbhd->onhl[1] = 1;
  nbhd->onhl[2] = -(nx + 2);
  nbhd->onhl[3] = (nx + 2);
  nbhd->onhl[4] = -(nx + 2) * (ny + 2);
  nbhd->onhl[5] = (nx + 2) * (ny + 2);
  nbhd->onhl[6] = (nx + 1);
  nbhd->onhl[7] = -nx - 1;
  /* set neighbourhood index array into new (non-padded) array */
  nbhd->nnhl[0] = -1;
  nbhd->nnhl[1] = 1;
  nbhd->nnhl[2] = -nx;
  nbhd->nnhl[3] = nx;
  nbhd->nnhl[4] = -nx * ny;
  nbhd->nnhl[5] = nx * ny;
  nbhd->nnhl[6] = nx - 1;
  nbhd->nnhl[7] = -nx + 1;
  /* set neighbourhood index array into old (padded) array */
  nbhd->onhr[0] = -1;
  nbhd->onhr[1] = 1;
  nbhd->onhr[2] = -(nx + 2);
  nbhd->onhr[3] = (nx + 2);
  nbhd->onhr[4] = -(nx + 2) * (ny + 2);
  nbhd->onhr[5] = (nx + 2) * (ny + 2);
  nbhd->onhr[6] = (nx + 3);
  nbhd->onhr[7] = -(nx + 3);
  /* set neighbourhood index array into new (non-padded) array */
  nbhd->nnhr[0] = -1;
  nbhd->nnhr[1] = 1;
  nbhd->nnhr[2] = -nx;
  nbhd->nnhr[3] = nx;
  nbhd->nnhr[4] = -nx * ny;
  nbhd->nnhr[5] = nx * ny;
  nbhd->nnhr[6] = nx + 1;
  nbhd->nnhr[7] = -nx - 1;
/************************************************/
/* Set up oct neighbourhoods....                */
/************************************************/
  /* set neighbourhood index array into old (padded) array */
  nbhd->ono[0] = -1;
  nbhd->ono[1] = 1;
  nbhd->ono[2] = -(nx + 2);
  nbhd->ono[3] = (nx + 2);
  nbhd->ono[4] = -(nx + 2) * (ny + 2);
  nbhd->ono[5] = (nx + 2) * (ny + 2);
  nbhd->ono[6] = (nx + 1);
  nbhd->ono[7] = (nx + 3);
  nbhd->ono[8] = -(nx + 3);
  nbhd->ono[9] = -(nx + 1);
  /* set neighbourhood index array into new (non-padded) array */
  nbhd->nno[0] = -1;
  nbhd->nno[1] = 1;
  nbhd->nno[2] = -nx;
  nbhd->nno[3] = nx;
  nbhd->nno[4] = -nx * ny;
  nbhd->nno[5] = nx * ny;
  nbhd->nno[6] = nx - 1;
  nbhd->nno[7] = nx + 1;
  nbhd->nno[8] = -nx - 1;
  nbhd->nno[9] = -nx + 1;
/******************************************* *****/
/* set up cubic (27) neighbourhood               */
/******************************************* *****/
  /* set neighbourhood index array into old (padded) array */
  /* set neighbourhood index array into old (padded) array */

  cnpt = nbhd->onc;
  zup = (nx + 2) * (ny + 2);
  for (k = -1; k < 2; k++) {
    for (j = -1; j < 2; j++) {
      for (i = -1; i < 2; i++) {
        *cnpt = (k * zup + j * (nx + 2) + i);
        cnpt += (*cnpt == 0 ? 0 : 1);
      }                         /*i */
    }                           /*j */
  }                             /*k */

  /* set neighbourhood index array into new (non-padded) array */
  zup = nx * ny;
  cnpt = nbhd->nnc;
  for (k = -1; k < 2; k++) {
    for (j = -1; j < 2; j++) {
      for (i = -1; i < 2; i++) {
        *cnpt = (k * zup + j * nx + i);
        cnpt += *cnpt == 0 ? 0 : 1;
      }                         /*i */
    }                           /*j */
  }                             /*k */

}                               /* end of nbhd_def subroutine */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_nbhd_def_c ()
{
  static char const rcsid[] = "$Id: nbhd_def.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_nbhd_def_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.16.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:37  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:02  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:35  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.2  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
