#include "machine.h"
#include <stdio.h>
#include <math.h>
/*******************************************/
/*******************************************/
/*******************************************/
/*******************************************/
/* Functions for the nuc-function table    */
/*******************************************/
/* These functions generate the desired    */
/* distribution of N as a function of U    */
/* using three input parameters.           */
/*******************************************/
/*******************************************/
CA_FLOAT nuc_func_norm (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = p2 * 1 / (p1 * SQRT (2.0 * 3.14159)) * EXP (-((Unuc - p3) * (Unuc - p3)) / (2 * p1 * p1));
  return (result);
}

CA_FLOAT nuc_func_pow (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc > p1) ? p2 * POW ((Unuc - p1), p3) : 0;
  return (result);
}

CA_FLOAT nuc_func_square (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc > p1) ? p2 * (Unuc - p1) * (Unuc - p1) : 0;
  return (result);
}

CA_FLOAT nuc_func_delta (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc == p3) ? p2 : 0;
  return (result);
}

CA_FLOAT nuc_func_step (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

  result = (Unuc > p3 && Unuc < p1 + p3) ? p2 : 0;
  return (result);
}

CA_FLOAT nuc_func_user (CA_FLOAT Unuc, CA_FLOAT p1, CA_FLOAT p2, CA_FLOAT p3)
{
  CA_FLOAT result;

/*******************************************/
/* Set result equal to a three parameter   */
/* function of Unuc to generate a distribu */
/* -tion of nuclation effectiveness        */
/*******************************************/
  result = 0;
/*         result = (Unuc > p1 && Unuc < p1+p3 )? p2:0;*/
  fprintf (stderr, "nuc_func_user: ERROR: function not defined!");
  exit (0);
  return (result);
}

/*******************************************/
/* Classical Nucleation Function of U,Tund */
/*******************************************/
CA_FLOAT nuc_function (CA_FLOAT Tund, CA_FLOAT Unuc)
{

  CA_FLOAT result;

  if (Tund <= 0)
    result = 0;
  else
    result = K_ONE * EXP (-Unuc / (Tund * Tund));
  return (result);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_nuc_functions_c ()
{
  static char const rcsid[] = "$Id: nuc_functions.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
