
/*-----------------------------------------------------------------*/
/*			    	reading in VAR marco resutls
 *
 *			    	added with external temperauture  LY 2009*/
/*-----------------------------------------------------------------*/


#include "phy_ca_tran.h"


/*----------------- reading in the dump files for Marco-----------------*/

int phy_readin(BB_struct *bp, int fcount) {

  int ang,r,z;
  int itim;
  int temp;
  CA_FLOAT ***phy_r, ***phy_a, ***phy_z;
  CA_FLOAT ***phy_fl,***phy_T;
  CA_FLOAT ***phy_u,***phy_v,***phy_w;

  char phyfn[MAX_STRING_LEN];
  FILE *fp, *testf;

  
  phy_r = bp->phy_r;
  phy_a = bp->phy_a;
  phy_z = bp->phy_z;
  phy_fl = bp->phy_fl;
  phy_u = bp->phy_u;
  phy_v = bp->phy_v;
  phy_w = bp->phy_w;
  phy_T = bp->phy_T;

  sprintf(phyfn, "data/dump%4.4d.dat", fcount);

  fprintf(stderr, "VAR_MACRO file name: %s \n", phyfn);

  if((fp = fopen(phyfn, "r")) == NULL){
	fprintf (stderr,"ERROR: phyfn : can't open file %s\n", phyfn);
	return 0;
  }
  fscanf(fp, "%d", &itim);
  fscanf(fp, ""SCAN_F"", &bp->phy_sim_time);
  fscanf(fp, "%d", &temp);

#ifdef TEST
  fprintf (stderr,"readin test: itim: %d, simu_time: %lf, sweep: %d\n", itim, bp->phy_sim_time, temp);
#endif

  for (ang=AMAX; ang>=1; ang--){
	for (z=1; z<=ZMAX; z++){
	  for (r=1; r<=RMAX; r++){
		if (z<=20 && r==27){
		  phy_r[r][z][ang]=0.25179;
		  phy_a[r][z][ang]=phy_a[r-1][z][ang];
		  phy_z[r][z][ang]=phy_z[r-1][z][ang];
		  phy_T[r][z][ang]=phy_T[r-1][z][ang];
		  phy_fl[r][z][ang]=phy_fl[r-1][z][ang];
		  phy_u[r][z][ang]=phy_u[r-1][z][ang];
		  phy_v[r][z][ang]=phy_v[r-1][z][ang];
		  phy_w[r][z][ang]=phy_w[r-1][z][ang];
		} else {
		  fscanf(fp,"%d", &temp);
		  fscanf(fp, ""SCAN_F"", &phy_r[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_a[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_z[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_T[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_fl[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_u[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_v[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &phy_w[r][z][ang]);
		  fscanf(fp, ""SCAN_F"", &temp);
		  fscanf(fp, ""SCAN_F"", &temp);
		  fscanf(fp, ""SCAN_F"", &temp);
		}

	  }
	}
  }
#ifdef TEST
  fprintf (stderr,"readin test: phy_r: %lf, phy_z: %lf, phy_T: %lf\n", phy_r[1][1][1], phy_z[1][1][1],phy_T[1][1][1]);
  fprintf (stderr,"readin test: phy_r: %lf, phy_z: %lf, phy_T: %lf\n", phy_r[RMAX][ZMAX][1], phy_z[RMAX][ZMAX][1],phy_T[RMAX][ZMAX][1]);
  fprintf (stderr,"readin test: phy_r: %lf, phy_z: %lf, phy_T: %lf\n", phy_r[20][26][1], phy_z[20][26][1],phy_T[20][26][1]);
  fprintf (stderr,"readin test: phy_r: %lf, phy_z: %lf, phy_T: %lf\n", phy_r[27][20][1], phy_z[27][20][1],phy_T[27][20][1]);
  fprintf (stderr,"readin test: phy_r: %lf, phy_z: %lf, phy_T: %lf\n", phy_r[RMAX-1][ZMAX-1][1], phy_z[RMAX-1][ZMAX-1][1],phy_T[RMAX-1][ZMAX-1][1]);
#endif


  fclose(fp);

#ifdef TEST
  testf=fopen("data.txt", "a+");
  fprintf(testf, "%.6f, %.6f, %.6f \n", phy_r[1][1][1],phy_z[1][1][1], phy_T[1][1][1]);
  fclose(testf);
#endif	
  
  return 1;
}

/*---------------- Marco  new data pass to old data array------------------*/

void datarestore(BB_struct *bp){
  
  int ang, r, z;
  for (ang=1; ang<=AMAX; ang++){
	for (z=1; z<=ZMAX; z++){
	  for (r=1; r<=RMAX; r++){  
		bp->phy_Told[r][z][ang] = bp->phy_T[r][z][ang];
		bp->phy_flold[r][z][ang] = bp->phy_fl[r][z][ang];
		bp->phy_uold[r][z][ang] = bp->phy_u[r][z][ang];
		bp->phy_vold[r][z][ang] = bp->phy_v[r][z][ang];
		bp->phy_wold[r][z][ang] = bp->phy_w[r][z][ang];
		
	  }
	}
  }

  bp->phy_sim_told = bp->phy_sim_time;
/*
  for (i=1; i<=IMAX; i++){
    for (j=1; j<=JMAX; j++){
 	  for (k=1; k<=KMAX; k++){
  	    bp->ca_Told[i][j][k]= bp->ca_T[i][j][k];
	  }
	}
  }
  */
}

/*------------store the new coordinates for CA cells-------------*/

void ca_cord_gen(BB_struct *bp, CA_FLOAT *orig){
  
  int i, j, k;
  CA_FLOAT ***ca_r, ***ca_a, ***ca_z;


  int IMAX, JMAX, KMAX;
  CA_FLOAT SIZEX,SIZEY,SIZEZ;

  IMAX = bp->tnc[0];
  JMAX = bp->tnc[1];
  KMAX = bp->tnc[2];
  SIZEX = bp->size_c[0];
  SIZEY = bp->size_c[1];
  SIZEZ = bp->size_c[2];
		  
  ca_r = bp->ca_r;
  ca_a = bp->ca_a;
  ca_z = bp->ca_z;

  for (i=1; i<=IMAX; i++){
    for (j=1; j<=JMAX; j++){
 	  for (k=1; k<=KMAX; k++){
		ca_r[i][j][k]=orig[0]+(i-1)*SIZEX;
		ca_z[i][j][k]=orig[1]+(j-1)*SIZEY;
		ca_a[i][j][k]=orig[2]+(k-1)*SIZEZ;
	  }
	}
  }

}

/*--------- ca_T is interpolated from orig and phy_T   ----*/

void phy_interp_slide(BB_struct *bp, CA_FLOAT *orig, CA_FLOAT ***phy_T, CA_FLOAT ***ca_T){

  int i, j, k;
  int ang, r, z;
  int tempr, tempz,tempang;
  CA_FLOAT dr, dz, da;
  CA_FLOAT ***ca_r, ***ca_a, ***ca_z;
//  CA_FLOAT ***ca_T;
  CA_FLOAT ***phy_r, ***phy_a, ***phy_z;
//  CA_FLOAT ***phy_T;
  CA_FLOAT tempT[6];

  int IMAX, JMAX, KMAX;
  CA_FLOAT SIZEX,SIZEY,SIZEZ;

  IMAX = bp->tnc[0];
  JMAX = bp->tnc[1];
  KMAX = bp->tnc[2];
  SIZEX = bp->size_c[0];
  SIZEY = bp->size_c[1];
  SIZEZ = bp->size_c[2];
		  
  ca_r = bp->ca_r;
  ca_a = bp->ca_a;
  ca_z = bp->ca_z;
//  ca_T = bp->ca_T;
  phy_r = bp->phy_r;
  phy_a = bp->phy_a;
  phy_z = bp->phy_z;
//  phy_T = bp->phy_T;

//  fprintf(stderr, "Radius %f  r %f ! \n", phy_r[1][1][1], phy_r[RMAX][ZMAX][AMAX]);
//   fprintf(stderr, "height %f  z %f ! \n", phy_z[1][1][1], phy_z[RMAX][ZMAX][AMAX]);
	 
  if(orig[0]<phy_r[1][1][1]) fprintf(stderr, "ERROR: The origin at r is too small!!! \n"), exit(0);
  if(orig[0]>phy_r[RMAX][ZMAX][1]) fprintf(stderr, "ERROR: The origin %f at r %f is too big!!! \n", orig[0], phy_r[RMAX][ZMAX][1]), exit(0);
  if(orig[1]<phy_z[1][1][1]) fprintf(stderr, "ERROR: The origin at z is too small!!! \n"), exit(0);
  if(orig[1]>phy_z[RMAX][ZMAX][AMAX]) fprintf(stderr, "ERROR: The origin at z is too big!!! \n"), exit(0);

  
  /*-------Main loop-------*/
  for (i=1; i<=IMAX; i++){
    for (j=1; j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){

		/*------find out where the ca cell locates------*/

		for (r=1; r<=RMAX; r++){
		  if(ca_r[i][j][k]==phy_r[r][1][1]){
			tempr=r;
			break;
		  }else if (ca_r[i][j][k]<phy_r[r][1][1]){ 
			tempr = r-1;
		    break;
		  }
		} // tempr

		for (z=1; z<=ZMAX; z++){
			if(ca_z[i][j][k]==phy_z[1][z][1]){
				tempz=z;
				break;
			}else if (ca_z[i][j][k]<phy_z[1][z][1]){ 
				tempz = z-1;
				break;
			}
		} //tempz

		for (ang=1; ang<=AMAX; ang++){
			if(ca_a[i][j][k]==phy_a[1][1][ang]){
				tempang=ang;
				break;
			}else if (ca_a[i][j][k]<phy_a[1][1][ang]){ 
				tempang = ang-1;   
				break;
			}
		} //tempang
        
        /*------ interpolation --------*/	
		dr = (ca_r[i][j][k]-phy_r[tempr][tempz][tempang])/(phy_r[tempr+1][tempz][tempang]-phy_r[tempr][tempz][tempang]);
		dz = (ca_z[i][j][k]-phy_z[tempr][tempz][tempang])/(phy_z[tempr][tempz+1][tempang]-phy_z[tempr][tempz][tempang]);
		da = (ca_a[i][j][k]-phy_a[tempr][tempz][tempang])/(phy_a[tempr][tempz][tempang+1]-phy_r[tempr][tempz][tempang]);  

		    /*---- different direction------*/
		tempT[0] = phy_T[tempr][tempz][tempang]+dr*(phy_T[tempr+1][tempz][tempang]-phy_T[tempr][tempz][tempang]);
		tempT[1] = phy_T[tempr][tempz+1][tempang]+dr*(phy_T[tempr+1][tempz+1][tempang]-phy_T[tempr][tempz+1][tempang]);
		tempT[2] = phy_T[tempr][tempz+1][tempang+1]+dr*(phy_T[tempr+1][tempz+1][tempang+1]-phy_T[tempr][tempz+1][tempang+1]);
		tempT[3] = phy_T[tempr][tempz][tempang+1]+dr*(phy_T[tempr+1][tempz][tempang+1]-phy_T[tempr][tempz][tempang+1]);
		tempT[4] = tempT[3]+dz*(tempT[2]-tempT[3]);
		tempT[5] = tempT[0]+dz*(tempT[1]-tempT[0]);

		ca_T[i][j][k] = tempT[5]+da*(tempT[4]-tempT[5])+273;  // In K 

	  }
	}
  } //end of main loop

}

void phy_interp_Tnow(BB_struct *bp, CA_FLOAT dtimenow, CA_FLOAT timegap){
 
  int i, j, k;
  CA_FLOAT ***ca_Tnow, ***ca_T, ***ca_Told;
  CA_FLOAT dgap;
  int IMAX, JMAX, KMAX;

  IMAX = bp->tnc[0];
  JMAX = bp->tnc[1];
  KMAX = bp->tnc[2];
		
  ca_Tnow = bp->ca_Tnow;
  ca_T = bp->ca_T;
  ca_Told = bp->ca_Told;

  dgap = dtimenow/timegap;

  for (i=1; i<=IMAX; i++){
    for (j=1; j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
		  ca_Tnow[i][j][k]= ca_Told[i][j][k]+dgap*(ca_T[i][j][k]-ca_Told[i][j][k]);
	  }
	}
  }


}


