/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/*RCS Id:$Id: pore.h 887 2006-03-01 18:21:01Z rcatwood $*/
/*pore header file - needed in blocks.h of course!*/
#ifndef PORE_H
#define PORE_H

#define POREREV "pore.h $Revision: 887 $"

#define N_T_LISTS 8
#define T_RAD_LIST  0
#define T_PRES_LIST 1
#define T_VOL_LIST  2
#define T_EQR_LIST  3
#define T_NMOL_LIST 4
#define T_LIM_LIST  5
#define T_NCELL_LIST  6 
#define T_FRACSOL_LIST  7 

/* names of each list for pore data printout */
#ifndef LISTNAMES
   #define LISTNAMES
  static const  char t_listnames[N_T_LISTS][25] = {
      "Rad/Length", /*0*/
      "Pressure",   /*1*/
      "Volume",     /*2*/
      "Eqiv. Rad.", /*3*/
      "N Mols",     /*4*/
      "Lim Rad",    /*5*/
      "Ncells",     /*6*/
      "FracSolid"   /*7*/
   };
#endif /*LISTNAMES*/


/*stored in the subblock*/

typedef struct pore_cell_node {
        int cellnum;
        int Cell[3];
        struct pore_cell_node * next;
        struct pore_cell_node * previous;

} p_c_node;

typedef struct pore_cell_list{
        p_c_node * first;
        p_c_node * last;
} p_c_list;

typedef struct pores {
   int Cellnum;    /* index of home cell for this pore*/
   int Cell[3];    /* xyz of cel with a pore */
   p_c_list * body;
   p_c_list * boundary;
   int ncells;
   CA_FLOAT Thresh;   /* nucleation temperature precalc. for this cell*/
   CA_FLOAT Radius;   /* radius of the pore in this cell*/
   CA_FLOAT EqRad;    /* equivalent spherical radius*/
   CA_FLOAT Limrad;   /* Limiting radius for spherical growth */
   CA_FLOAT base_Limrad;
   CA_FLOAT Oldrad;   /* Old effective radius */
   CA_FLOAT Newrad;   /* New effective radius */
   CA_FLOAT Volume;   /* The pore volume */
   CA_FLOAT Nmols;    /* Number of moles of gas in pore */
   CA_FLOAT NmolsH;   /* Number of mols of H2 added tothe pore since it started*/
   CA_FLOAT extra_nmols;
   CA_FLOAT sat;
   CA_FLOAT supersat;
   CA_FLOAT Pressure; /* the pressure in the pore */
   CA_FLOAT Startrad; /* starting radius of the pore in this cell*/
   CA_FLOAT Itime;    /* initialize dwell time */
   CA_FLOAT Stime;    /* sim time in pore */
   CA_FLOAT Time;     /* Dwell time of the pore.        */
   CA_FLOAT Mat;      /* Pore maturity function */
   CA_FLOAT NucSS;    /* supersaturation nucleation at which pore actually nucleated*/
   CA_FLOAT Temp;     /* current temperature*/
   CA_FLOAT NucTemp;  /* temperature at which the pore acutally nucleated */
   CA_FLOAT FracSol;  /* the averaged fraction solid of the pore bdy elements */
   int State;      /* PORE_ON or PORE_OFF or PORE_NONE ore PORE_TUBE or ...*/
   int trad_last;  /* last temperature benchmark index */


   CA_FLOAT ** t_lists; /* array of all the lists at temperature benchmarks */
} PORE_str;

/*need only once in bigblock*/
typedef struct poreprops {
   int P_nmeth;   /*GAUSS or STEP */
   CA_FLOAT (*pore_rand_function) (CA_FLOAT * params); /* random number function with required distribution */
   CA_FLOAT Binsize; /* size of temp. bins to use */
   CA_FLOAT P_nmax; /* nmax for the pore distrib. */
   CA_FLOAT P_tn;    /* center of gauss. dis. for pores */
   CA_FLOAT P_tsig;  /*spread of pore distrib*/
   CA_FLOAT P_par1;  /*user defined parameter*/
   CA_FLOAT P_par2;  /*user defined parameter*/
   /* for making the list of radius at steps of temperature */
   int P_ntrad;
   CA_FLOAT P_trad_max;
   CA_FLOAT P_trad_min;
   CA_FLOAT P_trad_step;
   CA_FLOAT P_limrad_perturb;
   /**/

} P_str;
#endif /*PORE_H*/
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:38  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:45  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:02  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.2  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.1.14.1  2002/09/13 09:10:18  rcatwood
RCS Log:only alloc C_E if decentered mode is on
RCS Log:started write_block for pore data - just a stub!
RCS Log:
RCS Log:Revision 7.1  2000/11/07 18:57:14  rcatwood
RCS Log:Altered T_lists and pore_max_fs
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.2  2000/10/24 14:55:52  rcatwood
RCS Log:before changing pore
RCS Log:
RCS Log:Revision 6.1  2000/10/16 10:37:22  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:37  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.1  2000/09/25 17:35:30  rcatwood
RCS Log:Before synch with common version, Used for PORE_00 paper
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.6  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.5  2000/06/29 14:31:02  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.4  2000/06/27 11:41:19  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.3  2000/06/12 16:23:30  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.2  2000/06/06 18:43:04  rcatwood
RCS Log:Changed r start and growth of pores -- pore radius equilibrium
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
