/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/*RCS Id:$Id: prop_wrapper.c 887 2006-03-01 18:21:01Z rcatwood $*/
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:38  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:45  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:02  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 4.3  2000/01/27 12:18:48  rcatwood
RCS Log:Overgrowth addressed. Bindump of t, fs
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
*/
/* include system headers */
#include "stdio.h"
#include "math.h"
#include "time.h"

/* include header files requred by subroutines */
#include "machine.h"
#include "read_ctrl.h"          /* included for def. of READ_CTRL subroutine */
#include "blocks.h"             /* included for def. of INIT_BB, CALC_BB, FINISH_BB */

/* functions used from ca_solid.c */
extern int ca_solid (int stat_flag, CA_FLOAT time, CA_FLOAT delt, Ctrl_str * cp);

/* functions used from read_ctrl.c */
extern int read_ctrl (char *filename, Ctrl_str * cp);

#ifdef DEBUG
FILE *efd;
#endif /* DEBUG */

void print_usage (char *prog_name)
{                               /* print the usage message on error */
  fprintf (stderr, "   %s: Use the CA method to simulate grain\n", prog_name);
  fprintf (stderr, "   nucleation and growth.\n");
  fprintf (stderr, "   %s acts as a wrapper to test the ca_solid\n", prog_name);
  fprintf (stderr, "   that can also be called from the FEM software CAP.\n");
  fprintf (stderr, "   We also plan to allow postprocessing FEM results.\n");
  fprintf (stderr, "\n   Usage: %s contro_file\n", prog_name);
  fprintf (stderr, "\tWhere the control_file if supplied, tells the\n");
  fprintf (stderr, "\tprgramme which files to read information from.\n");
  fprintf (stderr, "\tThe following command line options are allowed:\n");
  fprintf (stderr, "\t-?\t\t-> print this message\n");
  fprintf (stderr, "\t\n");
}

/****************************************************************/
/* Beginning of the MAIN program!				*/
/* This is just a wrapper to simulate the grain subroutine	*/
/* being called from within CAP. It asks a few questions	*/
/* that that CAP would know, and then goes on from there.	*/
/* It gives you the option to enter all the thermophysical	*/
/* data that would be read from a file if using CAP.		*/
/* This file must be in the current directory called ca_mp.dat	*/
/****************************************************************/
extern CA_FLOAT get_dl (CA_FLOAT temp);
extern CA_FLOAT get_ds (CA_FLOAT temp);
extern CA_FLOAT schiel (CA_FLOAT Tcell);
extern CA_FLOAT find_sch_conc (CA_FLOAT tempK, CA_FLOAT fl);
extern CA_FLOAT find_sat (CA_FLOAT cell_tempK, CA_FLOAT cell_si, CA_FLOAT cell_fs);
extern CA_FLOAT getav_d (CA_FLOAT dl, CA_FLOAT ds, CA_FLOAT fs);

void main (int argc, char *argv[])
{

  /* declare counters and output variables for main */
  int i;
  int stat_flag = -1;           /* stage in analysis: -1=before, 0=during, 1=final */

  /* variables for input */
  Ctrl_str ctrl, *cp;
  int cflg, errflg;
  int finput = FALSE;           /* inquire control info from user as default */
  char *ctrl_fname;

  int step, pr_step;
  CA_FLOAT ptime, del_ptime = 1.0;
  CA_FLOAT time = 0.0;
  CA_FLOAT delt = 1.0;
  char *time_string;            /* local date/time in string */
  FILE *propsfile;
  CA_FLOAT tempK, temp, tempdrop, tempstart, tempend;
  CA_FLOAT kH;
  CA_FLOAT d_av, ss, Hinit, Hliq, Hsol, dl, ds, fs, con, cellsat, cellsatFU;

  propsfile = fopen ("props.txt", "w");

  kH = 0.1;
  Hinit = .816;
  cp = &ctrl;
  tempstart = 650;
  tempend = 550;
  tempdrop = 1.0;
#ifdef NORMAL
  fprintf (propsfile, "temp\tdl\tds\tfs\td_av\tsi-con\tHliq-FU\tcellsat\tcellsatFU\tHss\n");

  for (temp = tempstart; temp > tempend; temp -= tempdrop) {
    tempK = temp + STD_TEMP;
    dl = get_dl (temp);
    ds = get_ds (temp);
    fs = schiel (temp);
    d_av = getav_d (dl, ds, fs);
    con = find_sch_conc ((tempK), (1 - fs));
    cellsat = find_sat (tempK, con, fs);
    cellsatFU = cellsat / MPMETERCUB;
    Hliq = Hinit / (1 - (1 - kH) * fs);
    ss = Hliq / cellsatFU;
    fprintf (propsfile, "%.10g\t%.10g\t%.10g\t%.10g\t%.10g\t%.10g\t%.10g\t%.10g\t%.10g\t%.10g\n", temp, dl, ds, fs, d_av, con, Hliq,
             cellsat, cellsatFU, ss);
  }
#endif /* NORMAL */
  fprintf (propsfile, "temp/con");
  for (con = 7; con < 12.5; con += 0.1) {
    fprintf (propsfile, "\t%.5g", con);
  }
  fprintf (propsfile, "\n");

  for (temp = tempstart; temp > tempend; temp -= tempdrop) {
    tempK = temp + STD_TEMP;
    fprintf (propsfile, "%.5g", temp);
    for (con = 7; con < 12.5; con += 0.1) {
      cellsat = find_sat (tempK, con, 0.5);
      fprintf (propsfile, "\t%.5g", cellsat);

    }
    fprintf (propsfile, "\n");
  }

  fclose (propsfile);
  fprintf (stderr, "Finshed making %s\n", "props.txt");
  exit (0);
}                               /* end of main program, ca_wrapper */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_prop_wrapper_c ()
{
  static char const rcsid[] = "$Id: prop_wrapper.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_prop_wrapper_c subroutine */
