#include <stdio.h>
#include <math.h>
#include "machine.h"

/* rand_step -- return a random number uniformly distributed between bottom and top */
CA_FLOAT rand_step (CA_FLOAT * params)
{
  CA_FLOAT bottom;
  CA_FLOAT width;

  /* make sure the parameters exist */
  if (params == NULL || (params + 1) == NULL) {
    fprintf (stderr, "ERROR: rand_step: You didn't give me enough information (NULL pointer)");
    fprintf (stderr, "ERROR: rand_step: You really need to debug this.");
    exit (1);
  }

  bottom = params[0];
  width = params[1];

  if ((bottom < 0) || (width <= 0)) {
    static int errmsg = 0;

    if (errmsg < MAX_ERR_MSG) {
      fprintf (stderr, "ERROR: rand_step: You can't ask me to do that! I quit! (bottom = %.5g width =%.5g) \n", bottom, width);
    }
#      ifdef ERROR_EXIT
    exit (1);
#      endif /*ERROR_EXIT */
  }
  return (bottom + drand48 () * width);
}                               /* end of rand_step */

/* rand_two_step  -- generate a random number distributed in two */
/* blocks, where the transition occurs at the point (middle) and changes */
/* by a factor (ratio) */
CA_FLOAT rand_two_step (CA_FLOAT * params)
{
  CA_FLOAT bottom, width1, width2, ratio;
  CA_FLOAT val, range;
  int i;

  /* make sure the parameters exist */
  for (i = 0; i < 4; i++) {
    if (params + i == NULL) {
      fprintf (stderr, "ERROR: rand_two_step: You didn't give me enough information (NULL pointer)");
      fprintf (stderr, "ERROR: rand_two_step: You really need to debug this.");
      exit (1);
    }
  }

  /* local variables */
  bottom = params[0];
  width1 = params[1];
  width2 = params[2];
  ratio = params[3];

  /* derived values */
  range = width1 + ratio * (width2);
  val = drand48 () * range;

  /* stretch the upper part by the ratio */
  if (val > width1) {
    val -= width1;
    val /= ratio;
    val += width1;
  }

  val += bottom;
  return (val);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_rand_step_c ()
{
  static char const rcsid[] = "$Id: rand_step.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
