/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/*      read_cap_ca.c:						*/
/*  Read in the geo info from a CAP CA file			*/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Jul 1, 1998                                                  */
/****************************************************************/
/* 	MODIFIED by:						*/
/*  PDL: Aug 19, 1998						*/
/****************************************************************/
/*RCS Id:$Id: read_cap_ca.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include "machine.h"
#include "fem.h"
#include "read_ctrl.h"
#include "blocks.h"

#ifdef DEBUG
FILE *efd;
#endif /* DEBUG */

/****************************************************************/
/*      Subroutine to read cap file                             */
/* This subroutine only reads the header and mask               */
/* array, the cell info is read in per sub-block                */
/****************************************************************/
/* pass in a blank BB structure, return with header filled    */

int read_cap_ca (Ctrl_str * cp, BB_struct * ptr_bb)
{
  /* just a stub */
#ifdef JUNK
  char command[MAX_STRING_LEN];
  int echo = TRUE;
  int i, j;                     /* tmp counters */
  CA_FLOAT tmp;                 /* tmp CA_FLOAT var. */
  FILE *fp;                     /* tmp filehandle */

/************************************************/
/* Read in geo from *****************************/
/************************************************/
/************************************************/
/* open BB input file and create output file	*/
/************************************************/
/* Open up input file				*/
  if ((fp = fopen (cp->fn_cap, "r")) == NULL) {
    fprintf (stderr, "Error: can't open input file [%s]\n", cp->fn_cap);
    /* ifd = stdin; echo = FALSE; */
  }
  ptr_bb->ibb_fd = fp;
  cp->fd_cap = fp;

/************************************************/
/* Read all the header data from the data file	*/
/************************************************/
  /* header 1 */
  fread (ptr_bb->header, sizeof (char), 256, fp);

  /* num. sub-blocks x, y, z */
  for (i = 0; i < 3; i++)
    fread (&(ptr_bb->nsb[i]), sizeof (int), 1, fp);
  fprintf (stderr, "nsb: %d, %d, %d\n", ptr_bb->nsb[0], ptr_bb->nsb[1], ptr_bb->nsb[2]);

  /* num. cells x, y, z */
  for (i = 0; i < 3; i++)
    fread (&(ptr_bb->tnc[i]), sizeof (int), 1, fp);
  fprintf (stderr, "ncells: %d, %d, %d\n", ptr_bb->tnc[0], ptr_bb->tnc[1], ptr_bb->tnc[2]);

  /* big block origin */
  for (i = 0; i < 3; i++)
    fread (&(ptr_bb->orig_bb[i]), sizeof (int), 1, fp);
  fprintf (stderr, "orig_bb: %f, %f, %f\n", ptr_bb->orig_bb[0], ptr_bb->orig_bb[1], ptr_bb->orig_bb[2]);

  /* cell dimensions */
  for (i = 0; i < 3; i++)
    fread (&(ptr_bb->size_c[i]), sizeof (int), 1, fp);
  fprintf (stderr, "cell dim: %f, %f, %f\n", ptr_bb->size_c[0], ptr_bb->size_c[1], ptr_bb->size_c[2]);

  /* num. casting nodes, elements */
  fread (&(ptr_bb->fem.nnodes), sizeof (int), 1, fp);
  fread (&(ptr_bb->fem.nelm), sizeof (int), 1, fp);
  fprintf (stderr, "nnodes: %d, nelm: %d\n", ptr_bb->fem.nnodes, ptr_bb->fem.nelm);

  /* extra space */
  fread (ptr_bb->tailer, sizeof (char), 200, fp);

/************************************************/
/* Finished reading header files, now           */
/* calc. all subsiduary values...		*/
/************************************************/
  ptr_bb->ntsb = ptr_bb->nsb[0] * ptr_bb->nsb[1] * ptr_bb->nsb[2];
  ptr_bb->ncsb = (ptr_bb->tnc[0] * ptr_bb->tnc[1] * ptr_bb->tnc[2]) / ptr_bb->ntsb;
  fprintf (stderr, "total #sb: %d, # cells/sb: %d\n", ptr_bb->ntsb, ptr_bb->ncsb);
  for (i = 0; i < 3; i++)
    ptr_bb->nc[i] = ptr_bb->tnc[i] / ptr_bb->nsb[i];
  fprintf (stderr, "#cells in x,y,z: %d, %d, %d\n", ptr_bb->nc[0], ptr_bb->nc[1], ptr_bb->nc[2]);
  for (i = 0; i < 3; i++)
    ptr_bb->size_bb[i] = (CA_FLOAT) ptr_bb->tnc[i] * ptr_bb->size_c[i];
  fprintf (stderr, "bigblock size: %f, %f, %f\n", ptr_bb->size_bb[0], ptr_bb->size_bb[1], ptr_bb->size_bb[2]);

/************************************************/
/* Malloc all SB mask for indexing CAP_CA file  */
/************************************************/
/* malloc an array to hold submask */
  if (!(ptr_bb->sb_mask = (long *) malloc (ptr_bb->ntsb * sizeof (long *)))) {
    fprintf (stderr, "ERROR: sb_mask array malloc failed\n");
    return (1);
  }

  fprintf (stderr, "before sb_mask nsb: %d, %d, %d\n", ptr_bb->nsb[0], ptr_bb->nsb[1], ptr_bb->nsb[2]);

/* read sub-block mask */
  fread (ptr_bb->sb_mask, sizeof (long), ptr_bb->ntsb, fp);
  for (i = 0; i < ptr_bb->ntsb; i++)
    fprintf (stderr, "sb_mask[%d]: %ld\n", i, ptr_bb->sb_mask[i]);

/*************************************/
/* Print out checks on input data... */
/*************************************/
  fprintf (stderr, "sb_mask nsb: %d, %d, %d\n", ptr_bb->nsb[0], ptr_bb->nsb[1], ptr_bb->nsb[2]);

  fprintf (stderr, "Exiting read_cap_ca().\n");
#endif /*JUNK*/
    return (0);
}                               /* end of read_cap_ca subroutine */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_read_cap_ca_c ()
{
  static char const rcsid[] = "$Id: read_cap_ca.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_read_cap_ca_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2  2003/11/18 13:22:40  rcatwood
RCS Log:Added routines to find and store the interface cells between the casting and the mould.
RCS Log:Added the surface cell storage structure to the subblock.
RCS Log:Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:38  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:45  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:03  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.1  2000/10/24 14:53:57  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:35  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.2  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
