#ifndef SUBBLOCK_H
#define SUBBLOCK_H
#define SUBBLOCKREV "subblock.h $Revision: 1482 $"

typedef struct subblock {
   int Npores;          /*Total possible pores in sb    */
   int code;            /* the code for which edge etc            */
   int done;            /* TRUE if finished substeps...           */
   int ncsolid;         /* number of solid cells in sb            */
   int ngr;             /* number of grains in sb                 */
   int nouts;           /* The flag for edge/cornr etc            */
   int nucnum;          /* number of grain boundary cells in sb   */
   int nmould;       /* number of "not casting" cells in sb    */
   int num;             /* subblock number                        */
   int open;            /* SB_NEW or SB_OPEN or SB_CLOSED   */
   int sb_npores;       /* number of active pores in sb */
   int orig_bb_idx[3];   /* big-block index of origin of the sb */
   CA_FLOAT orig_sb[3];    /* lower left front origin of sb in real space    */
   CA_FLOAT addsol;    /* amount of solute added in the step */
   CA_FLOAT t_addsol;  /* total amount of solute added since start */

   NODENB_str *nnd;     /* define for temperature interpolation. */
   NODENB_str *nnd_next;     /* define for temperature interpolation. */
   PORE_str *porelist;  /* list of cells with precalc. pore nuc.  */
   SB_nuc_str sbnuc;    /* defined in nucprops.h                  */
   S_struct Svals[2];      /* solute values in sb; see solprops.h    */
   T_struct Tvals;      /* temp and fl values in sb;see temprops.h*/
   SurCell surface;

   int *c_elm;          /* ptr to array of cell elm refs          */
   int *gr;             /* ptr to array of cell grain #           */
   int *index;          /* ptr to array of cell index:0=liq, 1=grain boundary, 2=inside grain*/ /*by Wei WANG on 11-07-02*/
/*   int *interface_index; REMOVED rcatwood 23/11/05 ptr to the interface of growing cell defined according to interface normal, for curvature calc only, xly, 2004/09/02 */ 
   int *nuclist;        /* ptr to array of grain boundary cell #  */

#ifdef CHIRAZI_MULTI
   CA_FLOAT **c_sol_alloy_multi; /*only for multi component*/
   CA_FLOAT **c_sol_n_eut_multi; /*only for multi component*/
   CA_FLOAT **c_sol_n_eut_old_multi; /*only for multi component*/
   CA_FLOAT **c_sol_tot_multi;   /*only for multi component*/
   CA_FLOAT **c_sol_tot_old_multi;   /*only for multi component*/
#endif



   
   CA_FLOAT *c_eqv_poly[NSOLMAX];  /*by Ludovic THUINET on 01-02-05*/
   CA_FLOAT *c_sol_poly[NSOLMAX]; /*by Ludovic THUINET on 01-02-05*/
   CA_FLOAT *c_fs_poly [NPHAMAX];/*by Ludovic THUINET on 05-05*/

   CA_FLOAT *c_fd;         /* ptr to array of cell state:            */
   CA_FLOAT *c_fs;         /* ptr to array of cell state:            */
   CA_FLOAT *c_fs_corrected;



   CA_FLOAT *c_nuc_thresh; /* cell nucleation threshold for grains     */

   int *nat_sol_site;   /*by THUINET 05/05*/
   int *nat_cell;       /*by THUINET 05/05*/
   int *nat_grain;      /* */


   CA_FLOAT *c_sol;        /* ptr to array of cell solute conc   for GAS    */
   CA_FLOAT *c_sol_alloy;  /* only used if PHASE DIAGRAM mode is on  */
   CA_FLOAT *c_eqv_alloy;  /* C_E:=C_S_fs+C_L*(1-fs)*/ /*by Wei WANG on 11-07-02*/

   CA_FLOAT *c_temp;       /* cell temperature */ /*by Wei WANG on 11-07-02*/
   CA_FLOAT *c_fg_temp;   /* cell temperature at macrostep 2d*/
   CA_FLOAT *c_fg_temp_next;  /* cell temperature at the next macro step*/
   CA_FLOAT *curv;         /* interface curvature */ /*by Wei WANG on 11-07-02*/
   CA_FLOAT *norm_x;       /* interface normal along x direction xly 2004/08/09 */ 
   CA_FLOAT *norm_y;       /* interface normal along y direction xly 2004/08/09 */
   CA_FLOAT *norm_z;       /* interface normal along z direction dn00 2005/10/18 */
   CA_FLOAT *dc_d;         /* decentred octahedron half diagonal */
   CA_FLOAT *dc_x;         /* centre x-coordinate */
   CA_FLOAT *dc_y;         /* centre y-coordinate */
   CA_FLOAT *dc_z;         /* centre z-coordinate */
   CA_FLOAT *cell_dfs_eutectic;
   CA_FLOAT *cell_dfs_primary;
   CA_FLOAT *fs_b_eut;
   CA_FLOAT *fs_b_eut_old;
   CA_FLOAT *fs_n_eut;
   CA_FLOAT *fs_n_eut_old;
   CA_FLOAT *fs_t_eut;
   CA_FLOAT *sch_fs;       /* Only used if SCHIEL mode is on          */

   CA_FLOAT *c_dfs;        /* Solid fraction changes for each cell, used in Latent heat*/
   CA_FLOAT *Tunder_curv;   /* curvature undercooling   lyuan  06/2008*/
   CA_FLOAT *ucmax;         /* max undercooling */
   CA_FLOAT *ucmax_t;       /* max undercooling happening time */
} SB_struct;

#endif /* SUBBLOCK_H */
