#define DEBUG_TC
/****************************************************************/
/*   Copyright (c 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*   email p.d.lee or r.atwood or x.xu @ic.ac.uk for details    */
/****************************************************************/

/****************************************************************/
/* thermo_trace_init.c:                                         */
/* Subroutine to initialise all variables and to                */
/* read in the values for a file.                               */
/*                                                              */
/* This subroutine is pard of the code to interpolate the       */
/* temperature at a point in the CA code using values           */
/* from a thermocouple trace                                    */
/****************************************************************/
/****************************************************************/
/* Written by X. Xu, P.D. Lee & R.C. Atwood, Imperial College   */
/* Dec 7 , 1998                                                  */
/****************************************************************/
/*      MODIFIED by:                                            */
/*                                                              */
/****************************************************************/
/****** To Do List **********************************************/
/*General:                                                      */
/* 1)                                                           */
/****************************************************************/
/*RCS Id:$Id: thermo_trace_init.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

/* include header files requred by subroutines */
#include "machine.h"
#include "tcpl.h"

/****************************************************************/
/****************************************************************/
/* thermo_trace_init:                                           */
/* Subroutine to init arrays and read in values.                */
/****************************************************************/
/* NOTE: the current version uses constant time step            */
/****************************************************************/
/** \todo  generalise to arbitrary (within reason) time steps -- input - coupled  */
/*                                                              */
/*                                                              */
/****************************************************************/
int thermo_trace_init (TC_str * tc)
{
  int errors = 0;
  FILE *fp;
  int i, j;                     /* temporary counters */

   /************************************************/
  /* Open the ascii trace infile to read          */
  /* the temperatures from.                       */
   /************************************************/
  if ((fp = fopen (tc->fn, "r")) == NULL) {
    printf ("ERROR: thermo_trace_init can not open input file [%s].\n", tc->fn);
    exit (1);
  }

   /****************************************************************/
  /* Read in the header line which holds:                         */
  /*    extra information                                         */
   /****************************************************************/
  fgets (tc->TC_header, MAX_STRING_LEN, fp);
  /*fscanf(fp, "%s\n", tc->TC_header); */
  fprintf (stderr, "TC Header info: %s\n", tc->TC_header);
   /****************************************************************/
  /* Read in the next line which holds:                         */
  /*    number of lines expected, timestep                        */
   /****************************************************************/
  fscanf (fp, "%d %g", &(tc->Nlines), &(tc->Tstep));
  fprintf (stderr, "TC Nlines, Tstep info: %i %f\n", tc->Nlines, tc->Tstep);

   /*************************************************/
  /* Malloc the arrays to hold time and temp values */
   /*************************************************/
  /* check for a bad number */
  if (tc->Nlines <= 1) {
    fprintf (stderr, "ERROR:thermo_trace_init: Not enough data lines specified! %i\n", tc->Nlines);
    exit (0);
  }
  /* malloc array of time values  */

  if (!(tc->Time = (float *) malloc (tc->Nlines * sizeof (float)))) {
    fprintf (stderr, "ERROR: thermo_trace_init  time array  malloc failed\n");
    return (2);
  }

  /* malloc array of temperatures */
  if (!(tc->Temp = (float *) malloc (tc->Nlines * sizeof (float)))) {
    fprintf (stderr, "ERROR: thermo_trace_init  temp array  malloc failed\n");
    return (3);
  }

   /************************************************/
  /* Now read in all the rest of the file.        */
   /************************************************/
  /* loop through reading the r locations         */
  for (i = 0; i < tc->Nlines; i++) {
    if (fscanf (fp, "%g %g", &tc->Time[i], &tc->Temp[i]) == NULL) {
      fprintf (stderr, "ERROR: thermo_trace_init ran out of data! %i\n", i);
      errors++;
    }
  }
  fclose (fp);
  return (errors);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_thermo_trace_init_c ()
{
  static char const rcsid[] = "$Id: thermo_trace_init.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_thermo_trace_init_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.5  2005/12/06 13:09:54  rcatwood
RCS Log:Changed todo lists to Doxygen syntax
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:48  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:40  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.2  2003/05/14 11:49:54  rcatwood
RCS Log:Fixed temperature input to conform wiht new temperature calculation methods
RCS Log:and control input file
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:47  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:04  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:35  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
