/*--------------------------------------*
 *        OUTPUT FOR PARAVIEW           *
 *					*
 *                   LY  11/2009	*
 *                                      *
 *-------------------------------------*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "machine.h"
#include "blocks.h"
#include "bigblock.h"
#include "props.h"
#include "readmat.h"

void vtk_para_op (BB_struct * bp, int sbnum){

  char fname[MAX_STRING_LEN];
  FILE *outfile;
  int totnum, indexnum;
  int i, j, k;
  CA_FLOAT Tliq, Tunder;
  
  totnum = bp->tnc[0]*bp->tnc[1]*bp->tnc[2];
  indexnum = 0;
  
  sprintf(fname, "PARA_%s_t%08d.vtk", bp->ctrl->fn_base, bp->step);
  
  if((outfile = fopen (fname, "w+")) == NULL) 
    fprintf(stderr, "ERROR: vtk_output: cannot open file: %s \n", fname);

  /*----------   write header  --------------*/
    
  fprintf(outfile, "# vtk DataFile Version 2.0 \n");
  fprintf(outfile, "uMatIC data for case [%s] \n", bp->ctrl->fn_base);
  fprintf(outfile, "ASCII \n");
  fprintf(outfile, "DATASET STRUCTURED_POINTS \n");
  fprintf(outfile, "DIMENSIONS %d %d %d \n", bp->tnc[0], bp->tnc[1], bp->tnc[2]);
  fprintf(outfile, "ORIGIN 0.0 0.0 0.0 \n");   /* can change to the bp->orig[3]*/
  fprintf(outfile, "SPACING 1 1 1 \n");         /* can swtich to cell size*/
  fprintf(outfile, "POINT_DATA %d \n\n", totnum);

  /*----------   output each variables --------------*/

  // solid fraction
  fprintf(outfile, "SCALARS Solid_Fraction double 1 \n");
  fprintf(outfile, "LOOKUP_TABLE default \n");

  for( k = 0; k < bp->tnc[2]; k++) {
    for (j = 0; j < bp->tnc[1]; j++) {
      for (i = 0; i < bp->tnc[0]; i++){
        fprintf(outfile, "%f\t", bp->sb[sbnum-1]->c_fs[indexnum]);
	indexnum ++;
      }
        fprintf(outfile, "\n");
    }
  }
  
  fprintf(outfile, "\n");

  // temperature
  
  indexnum = 0;
  fprintf(outfile, "SCALARS Temperature double 1 \n");
  fprintf(outfile, "LOOKUP_TABLE default \n");

  for( k = 0; k < bp->tnc[2]; k++) {
    for (j = 0; j < bp->tnc[1]; j++) {
      for (i = 0; i < bp->tnc[0]; i++){
        fprintf(outfile, "%f\t", bp->sb[sbnum-1]->c_temp[indexnum]);
        indexnum ++;
      }
        fprintf(outfile, "\n");
     }
   }

  fprintf(outfile, "\n");

  //grain number
  indexnum = 0;
  fprintf(outfile, "SCALARS Grain_Number double 1 \n");
  fprintf(outfile, "LOOKUP_TABLE default \n");

  for( k = 0; k < bp->tnc[2]; k++) {
    for (j = 0; j < bp->tnc[1]; j++) {
      for (i = 0; i < bp->tnc[0]; i++){
        fprintf(outfile, "%d\t", bp->sb[sbnum-1]->gr[indexnum]);
	indexnum ++;
      }
      fprintf(outfile, "\n");
    }
  }

 fprintf(outfile, "\n");
	  

  //solute concentration

  if(bp->ctrl->diffuse_alloy == TRUE && bp->ctrl->decentred_octahedron == TRUE){
    
    indexnum = 0;
    fprintf(outfile, "SCALARS Solute double 1 \n");
    fprintf(outfile, "LOOKUP_TABLE default \n");

    for( k = 0; k < bp->tnc[2]; k++) {
      for (j = 0; j < bp->tnc[1]; j++) {
        for (i = 0; i < bp->tnc[0]; i++){
          fprintf(outfile, "%f\t", bp->sb[sbnum-1]->c_eqv_alloy[indexnum]);
          indexnum ++;
        }
          fprintf(outfile, "\n");
      }
    }

    fprintf(outfile, "\n");

    indexnum = 0;
    fprintf(outfile, "SCALARS Const_UC double 1 \n");
    fprintf(outfile, "LOOKUP_TABLE default \n");

    for( k = 0; k < bp->tnc[2]; k++) {
      for (j = 0; j < bp->tnc[1]; j++) {
        for (i = 0; i < bp->tnc[0]; i++){
	  if (bp->sb[sbnum-1]->c_fs[indexnum] < 0.01) {
	    Tliq = cell_liq_calc (bp->sb[sbnum-1]->c_eqv_alloy[indexnum], &(bp->mprops));
	    Tunder = bp->mprops.Tliq - Tliq;
	  } else {
	    Tunder = 0;
	  }
          fprintf(outfile, "%f\t", Tunder);
          indexnum ++;
        }
          fprintf(outfile, "\n");
      }
    }
    fprintf(outfile, "\n");
		
 
  
    indexnum = 0;
    fprintf(outfile, "SCALARS Total_UC double 1 \n");
    fprintf(outfile, "LOOKUP_TABLE default \n");

    for( k = 0; k < bp->tnc[2]; k++) {
      for (j = 0; j < bp->tnc[1]; j++) {
        for (i = 0; i < bp->tnc[0]; i++){
	  if (bp->sb[sbnum-1]->c_fs[indexnum] < 0.01) {
	    Tliq = cell_liq_calc (bp->sb[sbnum-1]->c_eqv_alloy[indexnum], &(bp->mprops));
	    Tunder = bp->sb[sbnum-1]->c_temp[indexnum]- Tliq;
	  } else {
	    Tunder = 0;
	  }
          fprintf(outfile, "%f\t", Tunder);
          indexnum ++;
        }
          fprintf(outfile, "\n");
      }
    }
    fprintf(outfile, "\n");
  }		
  
  
  // vector velocity
  if(bp->ctrl->fluidflow == TRUE){
    
    indexnum = 0;
    fprintf(outfile, "VECTORS velocity double\n");

    for( k = 0; k < bp->tnc[2]; k++) {
      for (j = 0; j < bp->tnc[1]; j++) {
        for (i = 0; i < bp->tnc[0]; i++){
          fprintf(outfile, "%f %f %f \t", bp->ca_cell_uar[indexnum], bp->ca_cell_var[indexnum], bp->ca_cell_war[indexnum]);
          indexnum ++;
        }
          fprintf(outfile, "\n");
      }
    }

    fprintf(outfile, "\n");
  }
  
  if(bp->ctrl->maxucmap == 1){
    indexnum = 0;
    fprintf(outfile, "SCALARS MaxTunder double 1 \n");
    fprintf(outfile, "LOOKUP_TABLE default \n");

    for( k = 0; k < bp->tnc[2]; k++) {
      for (j = 0; j < bp->tnc[1]; j++) {
        for (i = 0; i < bp->tnc[0]; i++){
          fprintf(outfile, "%f\t", bp->sb[sbnum-1]->ucmax[indexnum]);
          indexnum ++;
        }
           fprintf(outfile, "\n");
      }
    }
    fprintf(outfile, "\n");
  }
  
  fclose(outfile);
 
  fprintf(stderr,"PARAVIEW: write the data file: %s ! \n", fname);
}
