/****************************************************************/
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM    */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      This material contains CONFIDENTIAL INFORMATION that    */
/*      is the property of Imperial College. Any use,           */
/*      duplication or disclosure not specifically authorized   */
/*      by Imperial College is strictly prohibited.             */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/****************************************************************/
/*      window_move_3d.c:                                          */
/*                                                              */
/* Subroutine of window moving                                  */
/* This file is added by LY on 02-10                   */
/*                                                              */
/*                                                              */
/*                                                              */
/****************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "machine.h"
#include "blocks.h"
#include "ca_matrix.h"

int window_move_3d (BB_struct * bp, int sbnum)
{
  SB_struct *sp;
  int i, j, k;                  /* tmp counter */
  int nx, ny, nz, nxy;
  int *ngr, *mgr;
  CA_FLOAT *nfs, *mfs, *ncl, *mcl, *nce, *mce;
/** \todo Moving would be better implemented by a move-array routine called for each array */

/*THUINET 02/05*/
  int isol, ele_num, ele_1;
  CA_FLOAT *ncl_poly[NSOLMAX], *mcl_poly[NSOLMAX], *nce_poly[NSOLMAX], *mce_poly[NSOLMAX];
  Ctrl_str *cp = bp->ctrl;

/*FIN THUINET 02/05*/

  CA_FLOAT *npd, *npx, *npy, *npz, *mpd, *mpx, *mpy, *mpz;

  sp = bp->sb[sbnum];

/*THUINET 03/05*/
  ele_num = cp->NUM_COMP;       /* number of elements in the alloy */
  ele_1 = ele_num - 1;
/*FIN THUINET 03/05*/

  nx = bp->nc[0];
  ny = bp->nc[1];
  nz = bp->nc[2];
  nxy = nx * ny;

  /* shift arrays of grain number and fraction solid */
  ngr = sp->gr;                 /* ptr to grain number of cell */
  nfs = sp->c_fs;               /* ptr to fractio solid */
  mgr = ngr + nxy;
  mfs = nfs + nxy;


  for (k = 0; k < nz -1; k++) {
      memcpy (ngr, mgr, nxy * sizeof (int));
      memcpy (nfs, mfs, nxy * sizeof (CA_FLOAT));
      ngr += nxy;
      mgr += nxy;
      nfs += nxy;
      mfs += nxy;
  }
    for (i = 0; i < nxy; i++) {  /* add a new row ny on the top */
      *ngr = 0;
      *nfs = 0.0;
      ngr++;
      nfs++;
    }
    mgr += nxy;
  

  /* shift arrays of C_L and C_E */
  if (bp->ctrl->diffuse_alloy == TRUE) {
    ncl = sp->c_sol_alloy;
    nce = sp->c_eqv_alloy;
    mcl = ncl + nxy;
    mce = nce + nxy;

      for (k = 0; k < nz - 1; k++) {
        memcpy (ncl, mcl, nxy * sizeof (CA_FLOAT));
        memcpy (nce, mce, nxy * sizeof (CA_FLOAT));
        ncl += nxy;
        mcl += nxy;
        nce += nxy;
        mce += nxy;
      }

      for (i = 0; i < nxy; i++) {
        *nce = *ncl = bp->mprops.alloyprops[0].Cinit;
        ncl++;
        nce++;
      }
      mfs += nxy;
      mcl += nxy;
      mce += nxy;
    }

  /* shift arrays of C_L and C_E in multicomponent for THUINET 03/05 */ // NOT updated
  if (bp->ctrl->diffuse_alloy_poly == TRUE) {

    for (isol = 0; isol < ele_1; isol++) {
      ncl_poly[isol] = sp->c_sol_poly[isol];
      nce_poly[isol] = sp->c_eqv_poly[isol];
      mcl_poly[isol] = ncl_poly[isol] + nx;
      mce_poly[isol] = nce_poly[isol] + nx;
    }

    for (k = 0; k < nz; k++) {
      for (j = 0; j < ny - 1; j++) {

        for (isol = 0; isol < ele_1; isol++) {

          memcpy (nce_poly[isol], mce_poly[isol], nx * sizeof (CA_FLOAT));
          memcpy (nce_poly[isol], mce_poly[isol], nx * sizeof (CA_FLOAT));
          ncl_poly[isol] += nx;
          mcl_poly[isol] += nx;
          nce_poly[isol] += nx;
          mce_poly[isol] += nx;

        }
      }

      for (i = 0; i < nx; i++) {

        for (isol = 0; isol < ele_1; isol++) {
          *nce_poly[isol] = *ncl_poly[isol] = bp->mprops.alloyprops[isol].Cinit;
          ncl_poly[isol]++;
          nce_poly[isol]++;
        }
      }

      mfs += nx;

      for (isol = 0; isol < ele_1; isol++) {
        mcl_poly[isol] += nx;
        mce_poly[isol] += nx;
      }
    }
  }

  /*End THUINET 03/05 */

  /* shift arrays for decentred octahedron */
  if (bp->ctrl->decentred_octahedron) {
    npd = sp->dc_d;             /* ptr to decentred octahedron half diagonal */
    npx = sp->dc_x;             /* ptr to decentred octahedron centre x */
    npy = sp->dc_y;             /* ptr to decentred octahedron centre y */
    npz = sp->dc_z;             /* ptr to decentred octahedron centre z */
    mpd = npd + nxy;
    mpx = npx + nxy;
    mpy = npy + nxy;
    mpz = npz + nxy;

      for (k = 0; k < nz - 1; k++) {
        memcpy (npd, mpd, nxy * sizeof (CA_FLOAT));
        memcpy (npx, mpx, nxy * sizeof (CA_FLOAT));
        memcpy (npy, mpy, nxy * sizeof (CA_FLOAT));
        memcpy (npz, mpz, nxy * sizeof (CA_FLOAT));
        npd += nxy;
        mpd += nxy;
        npx += nxy;
        mpx += nxy;
        npy += nxy;
        mpy += nxy;
        npz += nxy;
        mpz += nxy;
      }
      for (i = 0; i < nxy; i++) {
        *npd = 0.0;
        *npx = 0.0;
        *npy = 0.0;
        *npz = 0.0;
        npd++;
        npx++;
        npy++;
        npz++;
      }
      mpd += nxy;
      mpx += nxy;
      mpy += nxy;
      mpz += nxy;
  }

  return (1);
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *window_move_3d_c ()
{
  static char const rcsid[] = "$Id: window_move_3d.c 1480 2009-11-12 21:49:21Z rcatwood $";

  return (rcsid);
}
