/*$Id: write_POREprop_values.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"

void write_POREprop_values (FILE * fp, PORE_str * sp)
{
/* start of structure pores */
  int i;

  fprintf (fp, "\n\nPORE PROP STRUCTURE VALUES\n");
  fprintf (fp, "Cellnum %i \n", sp->Cellnum);
  fprintf (fp, "Cell ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %i ", sp->Cell[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "ncells %i \n", sp->ncells);
  fprintf (fp, "Thresh %g \n", sp->Thresh);
  fprintf (fp, "Radius %g \n", sp->Radius);
  fprintf (fp, "EqRad %g \n", sp->EqRad);
  fprintf (fp, "Limrad %g \n", sp->Limrad);
  fprintf (fp, "base_Limrad %g \n", sp->base_Limrad);
  fprintf (fp, "Oldrad %g \n", sp->Oldrad);
  fprintf (fp, "Newrad %g \n", sp->Newrad);
  fprintf (fp, "Volume %g \n", sp->Volume);
  fprintf (fp, "Nmols %g \n", sp->Nmols);
  fprintf (fp, "NmolsH %g \n", sp->NmolsH);
  fprintf (fp, "extra_nmols %g \n", sp->extra_nmols);
  fprintf (fp, "sat %g \n", sp->sat);
  fprintf (fp, "supersat %g \n", sp->supersat);
  fprintf (fp, "Pressure %g \n", sp->Pressure);
  fprintf (fp, "Startrad %g \n", sp->Startrad);
  fprintf (fp, "Itime %g \n", sp->Itime);
  fprintf (fp, "Stime %g \n", sp->Stime);
  fprintf (fp, "Time %g \n", sp->Time);
  fprintf (fp, "Mat %g \n", sp->Mat);
  fprintf (fp, "NucSS %g \n", sp->NucSS);
  fprintf (fp, "Temp %g \n", sp->Temp);
  fprintf (fp, "NucTemp %g \n", sp->NucTemp);
  fprintf (fp, "FracSol %g \n", sp->FracSol);
  fprintf (fp, "State %i \n", sp->State);
  fprintf (fp, "trad_last %i \n", sp->trad_last);
}

/* End of structure PORE_str */

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_POREprop_values_c ()
{
  static char const rcsid[] = "$Id: write_POREprop_values.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
