/*$Id: write_nprop_values.c 887 2006-03-01 18:21:01Z rcatwood $*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"

void write_nprop_values (FILE * fp, Nuc_str * np)
{
  fprintf (fp, "\n\nNUC PROP STRUCTURE VALUES\n");
  fprintf (fp, "nmodel, %i\n", np->nmodel);     /* type of nucleation model:            */
  fprintf (fp, "nhet, %i\n", np->nhet); /* number of different het. nuclei      */
  fprintf (fp, "nareanuc, %i\n", np->nareanuc); /* number of different area nucl. spec. */
  fprintf (fp, "ngr, %i\n", np->ngr);   /* number of grains                     */
  fprintf (fp, "gd_max, %.10g\n", np->gd_max);  /* max. grain density per [cm^3]        */
  fprintf (fp, "gd_max_total, %i\n", np->gd_max_total); /* total max. # grains for array size   */
  fprintf (fp, "oriented, %i\n", np->oriented); /* Orientation Calc: True/Flase         */
  fprintf (fp, "NucParams, %.10g, %.10g, %.10g, %.10g\n", np->NucParams[0], np->NucParams[1], np->NucParams[2], np->NucParams[3]);      /* the nucleation parameters array      */
  fprintf (fp, "perturb_on, %i\n", np->perturb_on);
  fprintf (fp, "n_perturb, %i\n", np->n_perturb);
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_nprop_values_c ()
{
  static char const rcsid[] = "$Id: write_nprop_values.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
