%%% MOTION DYNAMICS for DF
%zeroing
%=====================================================================================================================
q= zeros(2,N); qv= q; qa= q; 
IMPEDANCE= zeros(2,N); 
DIRECTION= zeros(2,N);
J11=0;J12=0;J21=0;J22=0;
force=zeros(2,N);
error=zeros(2,N);
x= zeros(2,N);
xv=x;
xa=x;
outflag=0;
out=650;


%Initialization of motion for first time instance
%======================================================================================================================

Q= qd(:,1);	Qv= qvd(:,1);	
q(:,1)= Q;	qv(:,1)= Qv;
H= mass(m,l,cl,I,Q);	C= coriolis(m,l,cl,Q,Qv);
m2= m(2); l1= l(1); l2= l(2);
i=1;
if trial==1
   JointTore(:,i)= PLAN(:,i);
else
   JointTore(:,i)= PLAN(:,i) + MEMO(:,i,trial-1);
end;
 
StiffnessProfile;
Ja= jacobian(l,q(:,1));
Jd= jacobian(l,qd(:,1));
J11(1)=Ja(1,1);
J12(1)=Ja(1,2);
J21(1)=Ja(2,1);
J22(1)=Ja(2,2);


X= kin(l,q(:,1));
x(:,1)= X;
xv(:,1)= Ja*Qv;
xa(:,1)=[0;0];
sum_error_xa=x(1,1)* xv(2,1)*dt;
Asum_error_xa=abs(x(1,1)* xv(2,1)*dt);


bumpq(:,i)=Ja'*bumpx(:,i);
if trial>1
    DIRECTION(:,i)= -meanerrorfuncy(trial-1)*sum_error_xa_vec(trial-1)*bumpq(:,i);
end;  
DIRX(:,i)=Ja'\DIRECTION(:,i);
%Motion simulation
%======================================================================================================================
i=2;
while (i<=N) %& (X(1)>-0.03) & (X(1)<0.03) %& (norm(X-[0;0.55])>0.0125) & curv<10  

    
	Qd= qd(:,i);	Qvd= qvd(:,i);
	e= qd(:,i) - Q;   ev= qvd(:,i) - Qv;
    IMPEDANCE(:,i)= Kq(:,:,i)*e + D(:,:,i)*ev;
    dampingforce(:,i)=D(:,:,i)*ev;

	bumpq(:,i)=Ja'*bumpx(:,i);


    if trial>1
        DIRECTION(:,i)= -meanerrorfuncy(trial-1)*sum_error_xa_vec(trial-1)*bumpq(:,i);
        DIRECTION(:,i)=[0;0];
    end;
	DIRX(:,i)=Ja'\DIRECTION(:,i);    
   
    if FIELD==1
        %if motion diverges to x1=+-0.03m cut force field and apply
        %damping force to restore path. After path falls within range again
        %damping force is cut and hand moves freely to the goal point.

        if (X(1)>-0.03)&(X(1)<0.03)			%within boundaires
            if outflag==0
                force(:,i-1)=Ke*x(:,i-1);	%when hand has not reached boundaries
            elseif outflag==1 
                force(:,i-1)=[0;0];			%when hand returns within the boudaries
            end;

        else 
            if outflag==0 					%when hand reaches boundaries
                out=i-1;
            end;
            outflag=1;
            force(:,i-1)=[40 0;0 0]*xv(:,out);  %damping force to return the hand to within the boundaries
        end;
    elseif FIELD==2
        force(:,i)=Be*xv(:,i-1);
    elseif FIELD==3
        force(:,i)=[0;0];
    end
        

          
    EXTERNAL= Ja'*force(:,i-1);
    if trial==1
   	Qa= H\(-EXTERNAL + PLAN(:,i) + MEMO(:,i,trial) + DIRECTION(:,i) +NOISE(:,i,trialreuse)+ IMPEDANCE(:,i) - C);
        JointTore(:,i)=PLAN(:,i);
	else
   	Qa= H\(-EXTERNAL + PLAN(:,i) + MEMO(:,i,trial-1) + DIRECTION(:,i)+NOISE(:,i,trialreuse)+ IMPEDANCE(:,i) - C);
        JointTore(:,i)=PLAN(:,i) + MEMO(:,i,trial-1);
	end;
    Qv= qv(:,i-1) + Qa*dt;
    Q= q(:,i-1) + Qv*dt + Qa*dt2/2;
    StiffnessProfile;
	qv(:,i)= Qv;	q(:,i)= Q;
    Ja= jacobian(l,q(:,i));
    Jd= jacobian(l,qd(:,i));
    X= kin(l,Q);
    x(:,i)= X;
   
    xv(:,i)= Ja*Qv;
    xa(:,i)=(xv(:,i)-xv(:,i-1))/dt;

	join(:,i)= mass(m,l,cl,I,Q)*Qa + coriolis(m,l,cl,Q,Qv);   

   
   	error(:,i)=X-xd(:,i);
   	if outflag==0 & (norm(X-[0;0.55])>0.0125)	
   		sum_error_xa= sum_error_xa + x(1,i)* abs(xv(2,i))*dt; %summing the errors---full integral
        Asum_error_xa=Asum_error_xa + abs(x(1,i)* xv(2,i)*dt);
    end;
       

   
    J11(i)= Ja(1,1);
   	J12(i)= Ja(1,2);
    J21(i)= Ja(2,1);
	J22(i)= Ja(2,2);



    H= mass(m,l,cl,I,Q);	C= coriolis(m,l,cl,Q,Qv);
   
  	i= i+1;   
end;
  
  

if (outflag==1) %calculates error when hand reaches side boundaries x=+-0.3

  	  sum_error_xa= sum_error_xa + abs(0.55-x(2,out))*x(1,out);
      Asum_error_xa= Asum_error_xa + abs((0.55-x(2,out))*x(1,out));
end;



if i<N
    X= x(:,i-1);  
	for j=i:N
   	x(:,j)= X;
    end;
    if x(2,i)<0.55
  		sum_error_xa= sum_error_xa + (0.55-x(2,i))*x(1,i);
        Asum_error_xa= Asum_error_xa + (0.55-x(2,i))*abs(x(1,i));
    end;
   
end;


%find mean jacobian for motion
%==============================================================================================================

J1(1,1)=mean(J11(100:300));
J1(1,2)=mean(J12(100:300));
J1(2,1)=mean(J21(100:300));
J1(2,2)=mean(J22(100:300));
