function handpatherror(AbsE,SgnE)

%==========================================================================
%This program plots the absolute and signed hand path errors with comparison
%to NF baseline.
%==========================================================================

load NFpatherror; %loads a saved instance of baseline hand path errors in NF
trial_num=min(length(AbsE),length(SgnE));
traxis=-9:1:trial_num;

figure
subplot(2,1,1);
bar(traxis,[AbsE_NF zeros(1,trial_num)],'g');
hold on;
bar(traxis,[zeros(1,10) AbsE]);
xlabel('trial no.')
ylabel('error [m^2]')
title('Absolute Handpath Error')

subplot(2,1,2);
bar(traxis,[SgnE_NF zeros(1,trial_num)],'g');
hold on;
bar(traxis,[zeros(1,10) SgnE]);
xlabel('trial no.')
ylabel('error [m^2]')
title('Signed Handpath Error')

