function FFm = learning(elambL,MJ,submov_num,FFm)

%==========================================================================
%This program updates the feedforward muscle force for the next trial based
%on the error signal for the current trial
%==========================================================================

global N phadv alpha beta decay

% smooth approximation of error signal via weighted sum of smooth basis functions
%===============================================================================
for i=1:N-phadv
    for mus=1:6
        if elambL(mus,i+phadv)>0
            tm(mus,i)=elambL(mus,i+phadv);
        else
            tm(mus,i)=-beta*elambL(mus,i+phadv);
        end 
    end
end
for i=N-phadv+1:N
    tm(:,i)=zeros(6,1);
end

for mus=1:6
     weights(:,mus)=lsqnonneg(MJ',(tm(mus,:))'); %determine the weights based on least squares approximation with nonnegativity constraint
end

sn=38/65;
subLF(1:round(submov_num*sn))=ones(1,round(submov_num*sn));
subLF(round(submov_num*sn)+1:submov_num)=0*ones(1,submov_num-round(submov_num*sn));

FBmL=weights'*diag(subLF)*MJ;


%updates the feedforward muscle force 
%===================================
FFm = FFm+ alpha*FBmL-decay;
for mus=1:6
     weightsp(:,mus)=lsqnonneg(MJ',FFm(mus,:)');
end;
FFm=weightsp'*MJ; %smoothens the waveform
for mus=1:6
    for i=1:650
        if FFm(mus,i)<0
            FFm(mus,i)=0;
        end
    end
end





