function [x2 elambL MUSCLE Kxmid AbsError SgnError] = motion(qd,qvd,xd,muscNOISE,FFm)

%==========================================================================
%This program computes the motion trajectories by simple integration of the 
%difference equation.
%==========================================================================

global dt N m l cl I Jm mid Ke Be bound delay  NA NB Kp Ka kappa_d rd gd Gr PFMmass PFMdamp statfric FIELD

outflag=0;  %for DF. Flag to indicate if hand exceeds wall
goalflag=0; %flag to indicate if hand has reached target circle
AbsError=0;
SgnError=0;
out=650;    %for DF. Time step at which hand exceeds wall.
q=zeros(2,N); qv=q; qa=q;
x=q;xv=q;xa=q;
force=q;
PFMdyn=q;
PFMdynX=q;
VFB=q;
VFB2=q;
FBm=zeros(6,N);
RFm=FBm;
FB=zeros(2,N);
RF=FB;
elambL=FBm;

i=1;

q(:,i)=qd(:,i);
x(:,i)=kin(l,q(:,i)); %forward kinematics
qv(:,i)=[0;0];
Ja=jacobian(l,q(:,i)); %Jacobian
Jadot=jacobiandot(l,q(:,i),qv(:,i));    %derivative of the Jacobian
xv(:,i)=Ja*qv(:,i);
H= mass(m,l,cl,I,q(:,i));	
C= coriolis(m,l,cl,q(:,i),qv(:,i)); 
Mnoise(:,i)=muscNOISE(:,i).*FFm(:,i)*NB+NA*muscNOISE(:,i);
M_actv(:,i)=FFm(:,i)+Mnoise(:,i)+RFm(:,i);
for mus=1:6
    if M_actv(mus,i)<0
        M_actv(mus,i)=0;
    end
end
MUSCLE(:,i)=M_actv(:,i)+FBm(:,i);
for mus=1:6
    if MUSCLE(mus,i)<0
        MUSCLE(mus,i)=0;
    end
end
ranNOISE(:,i)=Jm'*Mnoise(:,i); 
Km(:,:,i)=diag(Kp)+diag(Ka)*diag(M_actv(:,i)); %linear model of stiffness
Kq2(:,:,i)=Jm'*Km(:,:,i)*Jm;   %joint stiffness Kq2 derived from linear model
Kx(:,:,i)=Ja'\Kq2(:,:,i)/Ja;
x2(:,i)=x(:,i);
FF=Jm'*FFm; %computes the initial feedforward joint torque

for i=2:N
    %kinematic error
    %==================================================================
    e=qd(:,i-1)-q(:,i-1);
    ev=qvd(:,i-1)-qv(:,i-1);
    elamb(:,i)=Jm*e;        %compute kinematic error in muscle space
    elambv(:,i)=Jm*ev;



    %feedback
    %==================================================================
    FBm(:,i)=Km(:,:,i-1)*(elamb(:,i) + kappa_d*elambv(:,i)); 
    for mus=1:6
        if FBm(mus,i)<0
            FBm(mus,i)=0;
        end
    end
    FB(:,i)=Kq2(:,:,i-1)*(e + kappa_d*ev);  


    if i>delay+1
        RFm(:,i)=Gr*(elamb(:,i-delay) + rd*elambv(:,i-delay));
        for mus=1:6
            elambL(mus,i)=elamb(mus,i-delay) + gd*elambv(mus,i-delay); % computes the error signal for learning
            if RFm(mus,i)<0
                RFm(mus,i)=0;
            end
        end
        RF(:,i)=Jm'*RFm(:,i); 
    end

    if norm(x(:,i-1)-xd(:,N))<0.017
          VFB(:,i)=Ja'*[50 0;0 50]*(-xv(:,i-1));
    end
    if x(2,i-1)>=0.545
       VFB2(:,i)=Ja'*50*[1 0;0 1]*(-xv(:,i-1));
    end


    % Interaction with the environment
    %======================================================================
    if FIELD==2     %VF
        if (norm(x(:,i-1)-[xd(1,N);xd(2,N)])<=0.0125) || goalflag    %if hand reaches target circle, cut VF
            force(:,i)=[0;0];
            if ~goalflag
                goal=i;
            end;
            goalflag=1;
        else
            force(:,i)=Be*xv(:,i-1);  %external cartesian force
        end;
        EXT=Ja'*force(:,i);           %external torque

    elseif FIELD==1 %DF
        safetyzone;     %DF wall where force is cut 
        EXT=Ja'*force(:,i);

    elseif FIELD==3 %NF
        EXT=[0;0];
    end;

    %PFM dynamics
    %===========================================================================
    PFMdynX(:,i)=PFMdamp*xv(:,i-1)+tanh(diag(xv(:,i-1))*200)*statfric;
    PFMdyn(:,i)=Ja'*PFMdynX(:,i);
    op(:,i)=Ja'*PFMmass*Jadot*qv(:,i-1);

    % motion integration
    %==================================================================
    qa(:,i)=(H+Ja'*PFMmass*Ja)\(FF(:,i)+FB(:,i)+RF(:,i)-C+EXT-PFMdyn(:,i)-op(:,i)+ranNOISE(:,i-1)+VFB(:,i)+VFB2(:,i));
    qv(:,i)=qv(:,i-1)+qa(:,i)*dt;
    q(:,i)=q(:,i-1)+qv(:,i-1)*dt+0.5*qa(:,i)*dt*dt;

    x(:,i)=kin(l,q(:,i));
    if outflag==1
        x2(:,i)=x(:,out); %truncates discplacement along x-axis if outside safety zone (for DF only)
    else
        x2(:,i)=x(:,i);
    end
    Ja=jacobian(l,q(:,i));
    Jadot=jacobiandot(l,q(:,i),qv(:,i));

    xv(:,i)=Ja*qv(:,i);
    xa(:,i)=(xv(:,i)-xv(:,i-1))/dt;

    H= mass(m,l,cl,I,q(:,i));	
    C= coriolis(m,l,cl,q(:,i),qv(:,i));

    jointTorque(:,i)=FF(:,i)+FB(:,i)+RF(:,i)+EXT-PFMdyn(:,i)-op(:,i)+ranNOISE(:,i-1)+VFB(:,i)+VFB2(:,i);

    if outflag==0  
        if goalflag==0
            AbsError=AbsError + abs(x(1,i)*xv(2,i))*dt;     %Compute absolute and signed error
            SgnError=SgnError + (x(1,i)*xv(2,i))*dt;
        end;
    end;

    Mnoise(:,i)=muscNOISE(:,i).*FFm(:,i)*NB+NA*muscNOISE(:,i);
    ranNOISE(:,i)=Jm'*Mnoise(:,i);
    M_actv(:,i)=FFm(:,i)+Mnoise(:,i)+RFm(:,i);
    M_actv(3,i)=M_actv(3,i)+0.3*M_actv(5,i); %coupling between elbow and biarticular muscles
    M_actv(4,i)=M_actv(4,i)+0.3*M_actv(6,i);
    for mus=1:6
        if M_actv(mus,i)<0
            M_actv(mus,i)=0;
        end
    end
    MUSCLE(:,i)=M_actv(:,i)+FBm(:,i);
    for mus=1:6
        if MUSCLE(:,i)<0
            MUSCLE(:,i)=0;
        end
    end

    %stiffness update
    %================================================================
    Km(:,:,i)=diag(Kp)+diag(Ka)*diag(M_actv(:,i));      
    Kq2(:,:,i)=Jm'*Km(:,:,i)*Jm;
    EndpointForce= Ja'\jointTorque(:,i);
    Kxgeo=Gstiff(l,q(:,i),EndpointForce);
    Kx(:,:,i)=Ja'\(Kq2(:,:,i)-Kxgeo)/Ja;

end;

%if hand reaches wall in DF, impose penalty on handpath error incurred
if outflag==1
    AbsError=(AbsError + bound*abs(xd(2,N)-x(2,out)));
    SgnError=(SgnError + sign(x(1,out))*bound*abs((xd(2,N)-x(2,out))));
end;

Kxmid=Kx(:,:,mid);  %extract stiffness near middle of movement

    