global dt N m l cl I Jm mid trial_num Ke Be bound delay phadv NA NB Kp Ka kappa_d rd gd Gr PFMmass PFMdamp statfric alpha beta decay

dt=0.002;       % sampling period
N= 650;         % #(increments) -> duration = 1.3 s
trial_num=100;  % number of trials
mid=155;
trEnd=350;

%initialization of matrices
%======================================================================
FFm=zeros(6,N,trial_num);   % muscles feedforward (IM)
ffm=zeros(6,trial_num);     % to compute the mean feedforward
fbm=ffm;                    % to compute the mean feedback
AbsE=zeros(1,trial_num);    
SgnE=zeros(1,trial_num);
movtime=1000*(dt:dt:N*dt);
M_actv=zeros(6,N);
muscNOISE=FFm;
Kxmid=zeros(2,2,trial_num);
AbsE =zeros(1,trial_num);
SgnE=zeros(1,trial_num);

%arm model parameters
%======================================================================
m(1)= 1.93;     % mass of upper arm [kg]
m(2)= 1.52;     % mass of forearm [kg]
l(1)= 0.29;     % length of upper arm [m]
l(2)= 0.34;     % length of forearm [m]
cl(1)=0.165;    % position of center of mass of upper arm [m]
cl(2)=0.19;     % position of center of mass of forearm [m]
I(1)=0.0141;    % Mass moment of inertia for upper arm [kgm^2]
I(2)=0.0188;    % Mass moment of inertia for forearm [kgm^2]
d1=0.03; d2=0.03; d3=0.021; d4=0.021; d5=0.044; d6=0.044; d7=0.0338; d8=0.0338; % moment arms
Jm=[d1 0; -d2 0; 0 d3; 0 -d4; d5 d7; -d6 -d8]; 


%force fields
%====================================================
Ke=-[-450 0;0 0];     % for DF
Be=1*[13 -18; 18 13]; % for VF
bound=0.04; % boundary where DF is cut


delay=30; %neural delay in number of time steps (times two for ms. e.g. 30->60ms)
phadv=delay; %phase advance for learning law

%noise parameters
%====================================================
NB=0.04; 
NA=7;

%stiffness and reflex parameters
%====================================================
Kp=3360*ones(1,6);
Ka=0.035*Kp;  
kappa_d=1/12;
Gr=diag(Kp/10);
rd=2;
gd=0.2;

%PFM
%====================================================
PFMmass=[1.516 0;0 1.404];  
PFMdamp=[10.247 0;0 7.592];
statfric=[0.102;0.356];



%Learning parameters
%====================================================
alpha=9800;
beta=0.7;
decay=2*alpha/(1+1/beta)*0.00078;



