function [qd qvd qad xd xvd xad]=plankin(dataPoolx,dataPooly)

%==========================================================================
%This program computes the planned kinematics. Sets xd(1,:)=zeros to not 
%get any bias in DF.
%==========================================================================

global dt N l 

[B,A]=butter2(5,3/50);
qNF=zeros(2,N,50);
qvNF=qNF;
qaNF=qNF;
xNF=qNF;
xvNF=qNF;
xd=zeros(2,N);
xvd=xd;
xad=xd;
qd=xd;
qvd=xd;
qad=xd;

for trial=1:50
	for i=1:N
		xNF(1,i,trial)= dataPoolx(trial,i);
		xNF(2,i,trial)= dataPooly(trial,i); 
    end
	xNF(1,:,trial)= filtfilt(B,A,xNF(1,:,trial));
	xNF(2,:,trial)= filtfilt(B,A,xNF(2,:,trial));
	xvNF(:,:,trial)= differ(dt,xNF(:,:,trial));
    xvNF(1,:,trial)= filtfilt(B,A,xvNF(1,:,trial));
    xvNF(2,:,trial)= filtfilt(B,A,xvNF(2,:,trial));
    xaNF(:,:,trial)=differ(dt,xvNF(:,:,trial));
    xaNF(1,:,trial)= filtfilt(B,A,xaNF(1,:,trial));
    xaNF(2,:,trial)= filtfilt(B,A,xaNF(2,:,trial));
    i=1;
    qNF(:,i,trial)=invkin(l,xNF(:,i,trial));
    Ja=jacobian(l,qNF(:,i,trial));
    qvNF(:,i,trial)=Ja\xvNF(:,i,trial);
    qaNF(:,1,trial)=[0;0];

    for i=2:N
        qNF(:,i,trial)=invKin(l,xNF(:,i,trial));
        Ja=jacobian(l,qNF(:,i,trial));
        qvNF(:,i,trial)=Ja\xvNF(:,i,trial);
        qaNF(:,i,trial)=(qvNF(:,i,trial)-qvNF(:,i-1,trial))/dt;
    end;

end;


ind=1:50;

qd=mean(qNF(:,:,ind),3);
qd= qd*0;
meanqd=qd;
for trial=1:50
 k=1;
 xvabs= norm(xvNF(:,k,trial));
 while xvabs<0.001
     k=k+1;
     xvabs= norm(xvNF(:,k,trial));
 end;
 kstart=k;

 nend=N-kstart;
 nn= 0;
 for n=kstart:N
     nn= nn+1;
     meanqd(:,nn)= meanqd(:,nn) + qNF(:,n,trial);    
 end;
 for n=nend+1:N
     meanqd(:,n)= meanqd(:,n-1);    
 end;
end;
qd= meanqd/50;



for i=1:N
    xd(:,i)=kin(l,qd(:,i));
    xd(1,i)=0;
    qd(:,i)=invkin(l,xd(:,i));
    Ja=jacobian(l,qd(:,i));
    if i>1
        qvd(:,i)=(qd(:,i)-qd(:,i-1))/dt;
    end
    xvd(:,i)=Ja*qvd(:,i);
    if i>1
        xad(:,i)=(xvd(:,i)-xvd(:,i-1))/dt;
    end;
end

qad=differ(dt,qvd);
qvd(1,:)=filtfilt(B,A,qvd(1,:));
qvd(2,:)=filtfilt(B,A,qvd(2,:));
qad(1,:)=filtfilt(B,A,qad(1,:));
qad(2,:)=filtfilt(B,A,qad(2,:));


