function [MJ,submov_num]=submov
%==========================================================================
%This program computes basis functions that will be used to smoothen signals 
%==========================================================================

global dt N 

mjn=100;
T=mjn*dt;
t1=dt:dt:T;
t1=t1/(T);

submov_num=4*(N)/mjn-3;
MJ=zeros(submov_num,N);
weights=zeros(submov_num,6);

for i=1:submov_num
    starting=(i-1)*mjn/4+1;
    ending=(i+3)*mjn/4;
    MJ(i,starting:ending)=(30*t1.^4 - 60*t1.^3 + 30*t1.^2);
end;
